/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import com.supermartijn642.rechiseled.ChiselItem;
import com.supermartijn642.rechiseled.RechiseledBlocks;
import com.supermartijn642.rechiseled.RechiseledChiselingRecipes;
import com.supermartijn642.rechiseled.RechiseledClient;
import com.supermartijn642.rechiseled.api.blocks.RechiseledBlockType;
import com.supermartijn642.rechiseled.api.registration.RechiseledRegistration;
import com.supermartijn642.rechiseled.chiseling.PacketChiselingRecipes;
import com.supermartijn642.rechiseled.data.RechiseledItemModelGenerator;
import com.supermartijn642.rechiseled.data.RechiseledLanguageGenerator;
import com.supermartijn642.rechiseled.data.RechiseledRecipeGenerator;
import com.supermartijn642.rechiseled.data.RechiseledTextureProvider;
import com.supermartijn642.rechiseled.packet.PacketChiselAll;
import com.supermartijn642.rechiseled.packet.PacketSelectEntry;
import com.supermartijn642.rechiseled.packet.PacketToggleConnecting;
import com.supermartijn642.rechiseled.screen.ChiselContainer;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="rechiseled")
public class Rechiseled {
    public static final RechiseledRegistration REGISTRATION = RechiseledRegistration.get("rechiseled");
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"rechiseled");
    public static final Logger LOGGER = LogManager.getLogger((String)"rechiseled");
    @RegistryEntryAcceptor(namespace="rechiseled", identifier="chisel", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static ChiselItem chisel;
    @RegistryEntryAcceptor(namespace="rechiseled", identifier="chisel_container", registry=RegistryEntryAcceptor.Registry.MENU_TYPES)
    public static BaseContainerType<ChiselContainer> chisel_container;
    public static final CreativeItemGroup GROUP;

    public Rechiseled() {
        CHANNEL.registerMessage(PacketSelectEntry.class, PacketSelectEntry::new, true);
        CHANNEL.registerMessage(PacketToggleConnecting.class, PacketToggleConnecting::new, true);
        CHANNEL.registerMessage(PacketChiselAll.class, PacketChiselAll::new, true);
        CHANNEL.registerMessage(PacketChiselingRecipes.class, PacketChiselingRecipes::new, true);
        Rechiseled.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            RechiseledClient.register();
        }
        Rechiseled.registerGenerators();
        RechiseledBlocks.init();
        RechiseledChiselingRecipes.init();
    }

    public static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"rechiseled");
        handler.registerItem("chisel", ChiselItem::new);
        handler.registerMenuType("chisel_container", (ContainerType)BaseContainerType.create((container, buffer) -> buffer.writeBoolean(container.hand == Hand.MAIN_HAND), (player, buffer) -> new ChiselContainer((PlayerEntity)player, buffer.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND)));
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"rechiseled");
        handler.addProvider(RechiseledTextureProvider::new);
        handler.addGenerator(RechiseledItemModelGenerator::new);
        handler.addGenerator(RechiseledLanguageGenerator::new);
        handler.addGenerator(RechiseledRecipeGenerator::new);
        REGISTRATION.registerDataProviders();
    }

    static {
        GROUP = CreativeItemGroup.create((String)"rechiseled", () -> chisel).filler(stackConsumer -> {
            LinkedList<ChiselItem> items = new LinkedList<ChiselItem>();
            items.add(chisel);
            for (RechiseledBlockType type : REGISTRATION.getAllBlockTypes()) {
                items.add((ChiselItem)type.getRegularItem());
                items.add((ChiselItem)type.getConnectingItem());
            }
            items.stream().filter(Objects::nonNull).map(ItemStack::new).forEach((Consumer<ItemStack>)stackConsumer);
        });
    }
}

