/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.texture.TextureMappingTool;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.resources.IResource;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleResource;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class ChiseledTextureProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final String modid;
    private final DataGenerator generator;
    private final ExistingFileHelper existingFileHelper;
    private final Map<Pair<ResourceLocation, ResourceLocation>, PaletteMap> textures = new HashMap<Pair<ResourceLocation, ResourceLocation>, PaletteMap>();
    private final Set<String> outputLocations = new HashSet<String>();
    private final List<String> oakPlankSuffixes;

    public ChiseledTextureProvider(String modid, DataGenerator generator, ExistingFileHelper existingFileHelper) {
        this.modid = modid;
        this.generator = generator;
        this.existingFileHelper = existingFileHelper;
        this.oakPlankSuffixes = TextureMappingTool.getSuffixes("oak_planks", existingFileHelper);
    }

    public String func_200397_b() {
        return "Chiseled Textures: " + this.modid;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.createTextures();
        Path path = this.generator.func_200391_b();
        for (Map.Entry<Pair<ResourceLocation, ResourceLocation>, PaletteMap> entry : this.textures.entrySet()) {
            if (entry.getValue().targets.isEmpty()) continue;
            Pair<BufferedImage, JsonObject> oldPalette = this.loadTexture((ResourceLocation)entry.getKey().left());
            Pair<BufferedImage, JsonObject> newPalette = this.loadTexture((ResourceLocation)entry.getKey().right());
            Map targets = entry.getValue().targets;
            boolean ignoreMissingColors = entry.getValue().ignoreMissingColors;
            Map<Integer, Integer> colorMap = TextureMappingTool.createPaletteMap((BufferedImage)oldPalette.left(), (BufferedImage)newPalette.left());
            for (Map.Entry target : targets.entrySet()) {
                Pair<BufferedImage, JsonObject> targetTexture = this.loadTexture((ResourceLocation)target.getValue());
                String outputLocation = (String)target.getKey();
                TextureMappingTool.applyPaletteMap((BufferedImage)targetTexture.left(), colorMap, ignoreMissingColors, outputLocation);
                Path texturePath = path.resolve("assets/" + this.modid + "/textures/" + outputLocation + ".png");
                ChiseledTextureProvider.saveTexture(cache, (BufferedImage)targetTexture.left(), texturePath);
                if (targetTexture.right() == null) continue;
                Path textureMetadataPath = path.resolve("assets/" + this.modid + "/textures/" + outputLocation + ".png.mcmeta");
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)((JsonElement)targetTexture.right()), (Path)textureMetadataPath);
            }
        }
    }

    private Pair<BufferedImage, JsonObject> loadTexture(ResourceLocation location) {
        JsonObject metadata;
        BufferedImage image;
        if (!this.existingFileHelper.exists(location, ResourcePackType.CLIENT_RESOURCES, ".png", "textures")) {
            throw new IllegalStateException("Could not find existing texture: " + location);
        }
        try (IResource resource = this.existingFileHelper.getResource(location, ResourcePackType.CLIENT_RESOURCES, ".png", "textures");){
            image = ImageIO.read(resource.func_199027_b());
            resource.func_199028_a((IMetadataSectionSerializer)AnimationMetadataSection.field_195817_a);
            metadata = resource instanceof SimpleResource ? ((SimpleResource)resource).field_199037_g : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception when trying to load texture: " + location, e);
        }
        if (image.getType() != 2) {
            BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D graphics = newImage.createGraphics();
            graphics.drawImage((Image)image, 0, 0, null);
            graphics.dispose();
            image = newImage;
        }
        return Pair.of((Object)image, (Object)metadata);
    }

    private static void saveTexture(DirectoryCache cache, BufferedImage image, Path path) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", byteArrayOutputStream);
            byte[] bytes = byteArrayOutputStream.toByteArray();
            String hash = field_208307_a.hashBytes(bytes).toString();
            if (!Objects.equals(cache.func_208323_a(path), hash) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                    outputStream.write(bytes);
                }
            }
            cache.func_208316_a(path, hash);
        }
        catch (IOException exception) {
            System.err.println("Couldn't save texture '" + path + "'");
            exception.printStackTrace();
        }
    }

    private boolean validateTexture(ResourceLocation texture) {
        return this.existingFileHelper.exists(texture, ResourcePackType.CLIENT_RESOURCES, ".png", "textures");
    }

    private void trackTexture(String outputLocation) {
        this.existingFileHelper.trackGenerated(new ResourceLocation(this.modid, outputLocation), ResourcePackType.CLIENT_RESOURCES, ".png", "textures");
    }

    protected abstract void createTextures();

    protected PaletteMap createPaletteMap(ResourceLocation oldPalette, ResourceLocation newPalette) {
        if (!this.validateTexture(oldPalette)) {
            throw new IllegalStateException("Could not find texture '" + oldPalette + "'!");
        }
        if (!this.validateTexture(newPalette)) {
            throw new IllegalStateException("Could not find texture '" + newPalette + "'!");
        }
        return this.textures.computeIfAbsent((Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)oldPalette, (Object)newPalette), o -> new PaletteMap());
    }

    protected void createPlankTextures(ResourceLocation plankTexture, String outputLocation) {
        if (!this.validateTexture(plankTexture)) {
            throw new IllegalStateException("Could not find texture '" + plankTexture + "'!");
        }
        if (outputLocation == null || outputLocation.trim().isEmpty()) {
            throw new IllegalArgumentException("Output location must not be empty!");
        }
        if (!this.outputLocations.add(outputLocation)) {
            throw new IllegalStateException("Two or more textures have the same output location: " + outputLocation);
        }
        PaletteMap paletteMap = this.createPaletteMap(new ResourceLocation("minecraft", "block/oak_planks"), plankTexture);
        for (String suffix : this.oakPlankSuffixes) {
            paletteMap.applyToTexture(new ResourceLocation("rechiseled", "block/oak_planks" + suffix), outputLocation + suffix);
        }
    }

    protected class PaletteMap {
        private final Map<String, ResourceLocation> targets = new HashMap<String, ResourceLocation>();
        private boolean ignoreMissingColors = false;

        private PaletteMap() {
        }

        public PaletteMap applyToTexture(ResourceLocation texture, String outputLocation) {
            if (!ChiseledTextureProvider.this.validateTexture(texture)) {
                throw new IllegalStateException("Could not find texture '" + texture + "'!");
            }
            if (outputLocation == null || outputLocation.trim().isEmpty()) {
                throw new IllegalArgumentException("Output location must not be empty!");
            }
            if (!ChiseledTextureProvider.this.outputLocations.add(outputLocation)) {
                throw new IllegalStateException("Two or more textures have the same output location: " + outputLocation);
            }
            this.targets.put(outputLocation.toLowerCase(Locale.ROOT).trim(), texture);
            ChiseledTextureProvider.this.trackTexture(outputLocation);
            return this;
        }

        public PaletteMap ignoreMissing() {
            this.ignoreMissingColors = true;
            return this;
        }
    }
}

