/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.api;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.registry.Registries;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public abstract class ChiselingRecipeProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final String modid;
    private final DataGenerator generator;
    private final ExistingFileHelper existingFileHelper;
    private final Map<ResourceLocation, ChiselingRecipeBuilder> recipes = new HashMap<ResourceLocation, ChiselingRecipeBuilder>();

    public ChiselingRecipeProvider(String modid, DataGenerator generator, ExistingFileHelper existingFileHelper) {
        this.modid = modid;
        this.generator = generator;
        this.existingFileHelper = existingFileHelper;
    }

    public String func_200397_b() {
        return "Chiseling Recipes: " + this.modid;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.buildRecipes();
        Path path = this.generator.func_200391_b();
        for (Map.Entry<ResourceLocation, ChiselingRecipeBuilder> entry : this.recipes.entrySet()) {
            ResourceLocation recipeName = entry.getKey();
            ChiselingRecipeBuilder builder = entry.getValue();
            if (builder.parent != null) {
                ResourceLocation parentLocation;
                ResourceLocation parent = builder.parent;
                while (parent != null && parent.func_110624_b().equals(this.modid) && this.recipes.containsKey(parent)) {
                    parent = this.recipes.get(parent).parent;
                }
                if (parent != null && !this.existingFileHelper.exists(parentLocation = new ResourceLocation(parent.func_110624_b(), "chiseling_recipes/" + (parent.func_110623_a().endsWith(".json") ? parent.func_110623_a() : parent.func_110623_a() + ".json")), ResourcePackType.SERVER_DATA)) {
                    throw new IllegalStateException("Could not find upward parent '" + parent + "' at '/data/" + parentLocation.func_110624_b() + "/" + parentLocation.func_110623_a() + "' for chiseling recipe: " + recipeName);
                }
            }
            JsonObject json = ChiselingRecipeProvider.serializeRecipe(recipeName, builder);
            Path recipePath = path.resolve("data/" + recipeName.func_110624_b() + "/chiseling_recipes/" + recipeName.func_110623_a() + ".json");
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)recipePath);
        }
    }

    private static JsonObject serializeRecipe(ResourceLocation recipeName, ChiselingRecipeBuilder recipe) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "rechiseled:chiseling");
        if (recipe.parent != null) {
            json.addProperty("parent", recipe.parent.toString());
        }
        json.addProperty("overwrite", Boolean.valueOf(recipe.overwrite));
        HashSet items = Sets.newHashSet();
        JsonArray entries = new JsonArray();
        for (Triple entry : recipe.entries) {
            JsonObject object = new JsonObject();
            if (entry.getLeft() != null) {
                if (!items.add(entry.getLeft())) {
                    throw new IllegalStateException("Duplicate item '" + Registries.ITEMS.getIdentifier(entry.getLeft()) + "' in chiseling recipe '" + recipeName + "'");
                }
                object.addProperty("item", Registries.ITEMS.getIdentifier(entry.getLeft()).toString());
            }
            if (entry.getMiddle() != null) {
                if (!items.add(entry.getMiddle())) {
                    throw new IllegalStateException("Duplicate item '" + Registries.ITEMS.getIdentifier(entry.getMiddle()) + "' in chiseling recipe '" + recipeName + "'");
                }
                object.addProperty("connecting_item", Registries.ITEMS.getIdentifier(entry.getMiddle()).toString());
            }
            if (((Boolean)entry.getRight()).booleanValue()) {
                object.addProperty("optional", Boolean.valueOf(true));
            }
            entries.add((JsonElement)object);
        }
        json.add("entries", (JsonElement)entries);
        return json;
    }

    private void trackRecipe(ResourceLocation recipe) {
        this.existingFileHelper.trackGenerated(recipe, ResourcePackType.SERVER_DATA, ".json", "chiseling_recipes");
    }

    protected abstract void buildRecipes();

    protected ChiselingRecipeBuilder beginRecipe(String recipeName) {
        this.trackRecipe(new ResourceLocation(this.modid, recipeName));
        return this.recipes.computeIfAbsent(new ResourceLocation(this.modid, recipeName), s -> new ChiselingRecipeBuilder());
    }

    protected ChiselingRecipeBuilder beginRecipe(ResourceLocation recipe) {
        this.trackRecipe(recipe);
        return this.recipes.computeIfAbsent(recipe, s -> new ChiselingRecipeBuilder());
    }

    protected class ChiselingRecipeBuilder {
        private final List<Triple<Item, Item, Boolean>> entries = new LinkedList<Triple<Item, Item, Boolean>>();
        private ResourceLocation parent;
        private boolean overwrite = false;

        private ChiselingRecipeBuilder() {
        }

        @Deprecated
        public ChiselingRecipeBuilder parent(ResourceLocation parent) {
            this.parent = parent;
            return this;
        }

        public void overwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }

        public ChiselingRecipeBuilder add(@Nullable Item regularItem, @Nullable Item connectingItem, boolean optional) {
            if (regularItem == null && connectingItem == null) {
                throw new IllegalArgumentException("At least one of regular item or connecting item must not be null!");
            }
            this.entries.add((Triple<Item, Item, Boolean>)new ImmutableTriple((Object)regularItem, (Object)connectingItem, (Object)optional));
            return this;
        }

        public ChiselingRecipeBuilder add(Item regularItem, Item connectingItem) {
            return this.add(regularItem, connectingItem, false);
        }

        public ChiselingRecipeBuilder addRegularItem(Item item, boolean optional) {
            if (item == null) {
                throw new IllegalArgumentException("Item must not be null!");
            }
            return this.add(item, null, optional);
        }

        public ChiselingRecipeBuilder addRegularItem(Item item) {
            return this.addRegularItem(item, false);
        }

        public ChiselingRecipeBuilder addConnectingItem(Item item, boolean optional) {
            if (item == null) {
                throw new IllegalArgumentException("Item must not be null!");
            }
            return this.add(null, item, optional);
        }

        public ChiselingRecipeBuilder addConnectingItem(Item item) {
            return this.addConnectingItem(item, false);
        }
    }
}

