/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.chiseling;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class ChiselingRecipe {
    private final ResourceLocation recipeId;
    final ResourceLocation parentRecipeId;
    final boolean overwrite;
    private final List<ChiselingEntry> entries;

    private ChiselingRecipe(ResourceLocation recipeId, ResourceLocation parentRecipeId, boolean overwrite, Collection<ChiselingEntry> entries) {
        this.recipeId = recipeId;
        this.parentRecipeId = parentRecipeId;
        this.overwrite = overwrite;
        this.entries = Collections.unmodifiableList(Arrays.asList(entries.toArray(new ChiselingEntry[0])));
    }

    ChiselingRecipe(ResourceLocation recipeId, ResourceLocation parentRecipeId, Collection<ChiselingEntry> entries) {
        this(recipeId, parentRecipeId, false, entries);
    }

    public List<ChiselingEntry> getEntries() {
        return this.entries;
    }

    public boolean contains(ItemStack stack) {
        for (ChiselingEntry entry : this.entries) {
            if ((!entry.hasRegularItem() || entry.getRegularItem() != stack.func_77973_b()) && (!entry.hasConnectingItem() || entry.getConnectingItem() != stack.func_77973_b())) continue;
            return true;
        }
        return false;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public static class Serializer {
        public static ChiselingRecipe fromJson(ResourceLocation resourceLocation, JsonObject json) {
            ArrayList<ChiselingEntry> chiselingEntries = new ArrayList<ChiselingEntry>();
            String parentRecipeString = JSONUtils.func_151219_a((JsonObject)json, (String)"parent", null);
            ResourceLocation parentRecipe = parentRecipeString == null ? null : new ResourceLocation(parentRecipeString);
            boolean overwrite = JSONUtils.func_151209_a((JsonObject)json, (String)"overwrite", (boolean)false);
            if (!JSONUtils.func_151202_d((JsonObject)json, (String)"entries")) {
                throw new JsonParseException("Recipe must have an 'entries' array!");
            }
            JsonArray array = JSONUtils.func_151214_t((JsonObject)json, (String)"entries");
            for (JsonElement element : array) {
                Item connectingItem;
                Item regularItem;
                if (!element.isJsonObject()) {
                    throw new JsonParseException("Recipe entries must be json objects with 'item' and 'connecting_item' keys!");
                }
                JsonObject object = element.getAsJsonObject();
                if (!object.has("item") && !object.has("connecting_item")) {
                    throw new JsonParseException("Recipe entry must be have at least one of 'item' or 'connecting_item' keys!");
                }
                boolean optional = JSONUtils.func_151209_a((JsonObject)object, (String)"optional", (boolean)false);
                String regularItemName = JSONUtils.func_151219_a((JsonObject)object, (String)"item", (String)"");
                if (regularItemName.isEmpty()) {
                    regularItem = null;
                } else {
                    regularItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(regularItemName));
                    if (regularItem == null && !optional) {
                        throw new JsonParseException("Unknown item '" + regularItemName + "'");
                    }
                }
                String connectingItemName = JSONUtils.func_151219_a((JsonObject)object, (String)"connecting_item", (String)"");
                if (connectingItemName.isEmpty()) {
                    connectingItem = null;
                } else {
                    connectingItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(connectingItemName));
                    if (connectingItem == null && !optional) {
                        throw new JsonParseException("Unknown item '" + connectingItemName + "'");
                    }
                }
                if (regularItem == null && connectingItem == null) {
                    throw new JsonParseException("Recipe entry must be have at least one of 'item' or 'connecting_item' keys!");
                }
                chiselingEntries.add(new ChiselingEntry(regularItem, connectingItem));
            }
            return new ChiselingRecipe(resourceLocation, parentRecipe, overwrite, chiselingEntries);
        }

        public static ChiselingRecipe fromNetwork(PacketBuffer buffer) {
            ArrayList<ChiselingEntry> chiselingEntries = new ArrayList<ChiselingEntry>();
            ResourceLocation recipeId = buffer.func_192575_l();
            int entries = buffer.readInt();
            for (int i = 0; i < entries; ++i) {
                chiselingEntries.add(new ChiselingEntry(buffer.readBoolean() ? Item.func_150899_d((int)buffer.func_150792_a()) : null, buffer.readBoolean() ? Item.func_150899_d((int)buffer.func_150792_a()) : null));
            }
            return new ChiselingRecipe(recipeId, null, false, chiselingEntries);
        }

        public static void toNetwork(PacketBuffer buffer, ChiselingRecipe recipe) {
            buffer.func_192572_a(recipe.recipeId);
            buffer.writeInt(recipe.entries.size());
            for (ChiselingEntry entry : recipe.entries) {
                buffer.writeBoolean(entry.getRegularItem() != null);
                if (entry.getRegularItem() != null) {
                    buffer.func_150787_b(Item.func_150891_b((Item)entry.getRegularItem()));
                }
                buffer.writeBoolean(entry.getConnectingItem() != null);
                if (entry.getConnectingItem() == null) continue;
                buffer.func_150787_b(Item.func_150891_b((Item)entry.getConnectingItem()));
            }
        }
    }
}

