/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.chiseling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipes;
import com.supermartijn642.rechiseled.chiseling.PacketChiselingRecipes;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ChiselingRecipeLoader
implements IFutureReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();

    @SubscribeEvent
    public static void onAddReloadListener(AddReloadListenerEvent e) {
        e.addListener((IFutureReloadListener)new ChiselingRecipeLoader());
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent e) {
        if (e.getPlayer() == null) {
            Rechiseled.CHANNEL.sendToAllPlayers((BasePacket)new PacketChiselingRecipes(ChiselingRecipes.getAllRecipes()));
        } else {
            Rechiseled.CHANNEL.sendToPlayer((PlayerEntity)e.getPlayer(), (BasePacket)new PacketChiselingRecipes(ChiselingRecipes.getAllRecipes()));
        }
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage preparationBarrier, IResourceManager resourceManager, IProfiler profilerFiller, IProfiler profilerFiller2, Executor executor, Executor executor2) {
        List<CompletableFuture> recipes = resourceManager.func_199003_a("chiseling_recipes", s -> s.endsWith(".json")).stream().map(location -> CompletableFuture.supplyAsync(() -> ChiselingRecipeLoader.loadRecipe(resourceManager, location), executor)).collect(Collectors.toList());
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(recipes.toArray(new CompletableFuture[0])).thenApplyAsync(o -> ChiselingRecipeLoader.mergeRecipes(recipes.stream().map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toList())), executor)).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)preparationBarrier).func_216872_a(arg_0))).thenAcceptAsync(resolvedRecipes -> {
            Rechiseled.LOGGER.info("Loaded " + resolvedRecipes.size() + " chiseling recipes");
            ChiselingRecipes.setRecipes(resolvedRecipes);
        }, executor2);
    }

    private static ChiselingRecipe loadRecipe(IResourceManager resourceManager, ResourceLocation recipeLocation) {
        ResourceLocation parentRecipe = null;
        ArrayList<ChiselingEntry> entries = new ArrayList<ChiselingEntry>();
        try {
            for (IResource resource : resourceManager.func_199004_b(recipeLocation)) {
                JsonObject json;
                try (InputStreamReader reader = new InputStreamReader(resource.func_199027_b());){
                    json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                }
                catch (Exception e) {
                    Rechiseled.LOGGER.error("Encountered an exception whilst trying to load chiseling recipe json '" + recipeLocation + "' from '" + resource.func_199026_d() + "'!", (Throwable)e);
                    break;
                }
                ChiselingRecipe recipe = ChiselingRecipe.Serializer.fromJson(recipeLocation, json);
                if (recipe.overwrite) {
                    entries.clear();
                }
                entries.addAll(recipe.getEntries());
                if (recipe.parentRecipeId == null) continue;
                Rechiseled.LOGGER.warn("Chiseling recipe '" + recipe.getRecipeId() + "' from '" + resource.func_199026_d() + "' uses the 'parent' field! This will be removed in Rechiseled 1.2.0. Recipes automatically get merged based on entries!");
                parentRecipe = recipe.parentRecipeId;
                break;
            }
        }
        catch (Exception e) {
            Rechiseled.LOGGER.error("Encountered an exception whilst trying to load chiseling recipe '" + recipeLocation + "'!", (Throwable)e);
            return null;
        }
        return new ChiselingRecipe(recipeLocation, parentRecipe, entries);
    }

    /*
     * WARNING - void declaration
     */
    private static List<ChiselingRecipe> mergeRecipes(List<ChiselingRecipe> recipes) {
        void var5_13;
        LinkedHashMap recipeEntries = new LinkedHashMap();
        recipes.stream().sorted(Comparator.comparing(r -> r.getRecipeId().toString())).forEach(recipe -> {
            Set cfr_ignored_0 = recipeEntries.put(recipe.getRecipeId(), new LinkedHashSet<ChiselingEntry>(recipe.getEntries()));
        });
        LinkedHashMap<ResourceLocation, ChiselingRecipe> recipesWithParent = new LinkedHashMap<ResourceLocation, ChiselingRecipe>();
        for (ChiselingRecipe chiselingRecipe : recipes) {
            if (chiselingRecipe.parentRecipeId == null) continue;
            recipesWithParent.put(chiselingRecipe.getRecipeId(), chiselingRecipe);
        }
        block1: for (ChiselingRecipe chiselingRecipe : recipesWithParent.values()) {
            HashSet<ResourceLocation> hashSet = new HashSet<ResourceLocation>();
            ResourceLocation parentRecipe = chiselingRecipe.parentRecipeId;
            while (recipesWithParent.containsKey(parentRecipe)) {
                hashSet.add(parentRecipe);
                if (hashSet.contains(parentRecipe)) {
                    Rechiseled.LOGGER.error("Found circular parent references when trying to load chiseling recipe '" + chiselingRecipe.getRecipeId() + "': " + hashSet);
                    continue block1;
                }
                parentRecipe = ((ChiselingRecipe)recipesWithParent.get((Object)parentRecipe)).parentRecipeId;
            }
            if (parentRecipe == null) {
                Rechiseled.LOGGER.error("Could not find parent '" + parentRecipe + "' when trying to load chiseling recipe '" + chiselingRecipe.getRecipeId() + "'!");
                continue;
            }
            ((Set)recipeEntries.get(parentRecipe)).addAll(chiselingRecipe.getEntries());
        }
        HashMap itemsPerRecipe = new HashMap();
        for (Map.Entry entry2 : recipeEntries.entrySet()) {
            HashSet items = new HashSet();
            ((Set)entry2.getValue()).forEach(e -> {
                if (e.hasRegularItem()) {
                    items.add(e.getRegularItem());
                }
                if (e.hasConnectingItem()) {
                    items.add(e.getConnectingItem());
                }
            });
            itemsPerRecipe.put(entry2.getKey(), items);
        }
        ResourceLocation[] resourceLocationArray = recipeEntries.keySet().toArray(new ResourceLocation[0]);
        boolean bl = false;
        while (var5_13 < resourceLocationArray.length) {
            for (void j = var5_13 + true; j < resourceLocationArray.length; ++j) {
                if (Collections.disjoint((Collection)itemsPerRecipe.get(resourceLocationArray[var5_13]), (Collection)itemsPerRecipe.get(resourceLocationArray[j]))) continue;
                ((Set)recipeEntries.get(resourceLocationArray[j])).addAll((Collection)recipeEntries.get(resourceLocationArray[var5_13]));
                recipeEntries.remove(resourceLocationArray[var5_13]);
                ((Set)itemsPerRecipe.get(resourceLocationArray[j])).addAll((Collection)itemsPerRecipe.get(resourceLocationArray[var5_13]));
                itemsPerRecipe.remove(resourceLocationArray[var5_13]);
                break;
            }
            ++var5_13;
        }
        for (ResourceLocation location : recipeEntries.keySet()) {
            Set entries = (Set)recipeEntries.get(location);
            HashMap<Item, Integer> itemCounts = new HashMap<Item, Integer>();
            ((Set)itemsPerRecipe.get(location)).forEach(item -> itemCounts.compute((Item)item, (i, c) -> c == null ? 1 : c + 1));
            LinkedList<ChiselingEntry> toRemove = new LinkedList<ChiselingEntry>();
            for (ChiselingEntry entry2 : entries) {
                if (!entry2.hasRegularItem() && (Integer)itemCounts.get(entry2.getConnectingItem()) > 1) {
                    toRemove.add(entry2);
                    itemCounts.compute(entry2.getConnectingItem(), (i, c) -> c - 1);
                    continue;
                }
                if (entry2.hasConnectingItem() || (Integer)itemCounts.get(entry2.getRegularItem()) <= 1) continue;
                toRemove.add(entry2);
                itemCounts.compute(entry2.getRegularItem(), (i, c) -> c - 1);
            }
            toRemove.forEach(entries::remove);
        }
        recipes = recipeEntries.entrySet().stream().map(entry -> new ChiselingRecipe((ResourceLocation)entry.getKey(), null, (Collection)entry.getValue())).collect(Collectors.toList());
        return recipes;
    }
}

