/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration.data;

import com.supermartijn642.core.generator.LootTableGenerator;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.registration.RechiseledRegistrationImpl;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;

public class RegistrationLootTableGenerator
extends LootTableGenerator {
    private final RechiseledRegistrationImpl registration;

    public RegistrationLootTableGenerator(RechiseledRegistrationImpl registration, ResourceCache cache) {
        super(registration.getModid(), cache);
        this.registration = registration;
    }

    public void generate() {
        if (!this.registration.providersRegistered) {
            return;
        }
        this.registration.getBlockBuilders().stream().map(Pair::right).forEach(type -> {
            if (type.hasRegularVariant()) {
                this.addLootTable(type.getRegularBlock());
            }
            if (type.hasConnectingVariant()) {
                this.addLootTable(type.getConnectingBlock());
            }
        });
    }

    private void addLootTable(Block block) {
        ResourceLocation identifier = Registries.BLOCKS.getIdentifier((Object)block);
        ResourceLocation lootTable = block.func_220068_i();
        if (lootTable == null || lootTable.func_110624_b().equals(identifier.func_110624_b()) && lootTable.func_110623_a().equals("block/" + identifier.func_110623_a())) {
            return;
        }
        this.dropSelf(block);
    }
}

