/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.registration.data;

import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.TagGenerator;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockBuilderImpl;
import com.supermartijn642.rechiseled.blocks.RechiseledBlockTypeImpl;
import com.supermartijn642.rechiseled.registration.RechiseledRegistrationImpl;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraftforge.common.ToolType;

public class RegistrationTagsGenerator
extends TagGenerator {
    private final RechiseledRegistrationImpl registration;

    public RegistrationTagsGenerator(RechiseledRegistrationImpl registration, ResourceCache cache) {
        super(registration.getModid(), cache);
        this.registration = registration;
    }

    public void generate() {
        if (!this.registration.providersRegistered) {
            return;
        }
        this.registration.getBlockBuilders().forEach(pair -> {
            RechiseledBlockBuilderImpl builder = (RechiseledBlockBuilderImpl)pair.left();
            RechiseledBlockTypeImpl type = (RechiseledBlockTypeImpl)pair.right();
            if (type.hasRegularVariant()) {
                this.addTags(builder, type.getRegularBlock());
            }
            if (type.hasConnectingVariant()) {
                this.addTags(builder, type.getConnectingBlock());
            }
        });
    }

    private void addTags(RechiseledBlockBuilderImpl builder, Block block) {
        builder.tags.stream().map(arg_0 -> ((RegistrationTagsGenerator)this).blockTag(arg_0)).forEach(tag -> tag.add((Object)block));
        if (builder.miningTagsFromBlock != null) {
            this.getTagsForBlock(builder.miningTagsFromBlock).forEach(tag -> tag.accept(block));
        }
    }

    private List<Consumer<Block>> getTagsForBlock(Supplier<Block> block) {
        return Stream.of(Pair.of(() -> ((RegistrationTagsGenerator)this).blockMineableWithAxe(), b -> b.getHarvestTool(b.func_176223_P()) == ToolType.AXE), Pair.of(() -> ((RegistrationTagsGenerator)this).blockMineableWithHoe(), b -> b.getHarvestTool(b.func_176223_P()) == ToolType.HOE), Pair.of(() -> ((RegistrationTagsGenerator)this).blockMineableWithPickaxe(), b -> b.getHarvestTool(b.func_176223_P()) == ToolType.PICKAXE), Pair.of(() -> ((RegistrationTagsGenerator)this).blockMineableWithShovel(), b -> b.getHarvestTool(b.func_176223_P()) == ToolType.SHOVEL), Pair.of(() -> ((RegistrationTagsGenerator)this).blockNeedsStoneTool(), b -> b.getHarvestLevel(b.func_176223_P()) == 1), Pair.of(() -> ((RegistrationTagsGenerator)this).blockNeedsIronTool(), b -> b.getHarvestLevel(b.func_176223_P()) == 2), Pair.of(() -> ((RegistrationTagsGenerator)this).blockNeedsDiamondTool(), b -> b.getHarvestLevel(b.func_176223_P()) == 3)).filter(pair -> ((Predicate)pair.right()).test(block.get())).map(Pair::left).map(Supplier::get).map(builder -> arg_0 -> ((TagGenerator.TagBuilder)builder).add(arg_0)).collect(Collectors.toList());
    }
}

