/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseContainerWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.packet.PacketChiselAll;
import com.supermartijn642.rechiseled.packet.PacketSelectEntry;
import com.supermartijn642.rechiseled.packet.PacketToggleConnecting;
import com.supermartijn642.rechiseled.screen.BaseChiselingContainer;
import com.supermartijn642.rechiseled.screen.ChiselAllWidget;
import com.supermartijn642.rechiseled.screen.ConnectingToggleWidget;
import com.supermartijn642.rechiseled.screen.EntryButtonWidget;
import com.supermartijn642.rechiseled.screen.EntryPreviewWidget;
import com.supermartijn642.rechiseled.screen.PreviewModeButtonWidget;
import java.util.function.Supplier;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class BaseChiselingContainerScreen<T extends BaseChiselingContainer>
extends BaseContainerWidget<T> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("rechiseled", "textures/screen/chiseling_background.png");
    public static int previewMode = 0;
    private final ITextComponent title;
    private ChiselAllWidget chiselAllWidget;

    public BaseChiselingContainerScreen(ITextComponent title) {
        super(0, 0, 222, 226);
        this.title = title;
    }

    protected void addWidgets() {
        for (int row = 0; row < 5; ++row) {
            for (int column = 0; column < 5; ++column) {
                int index = row * 5 + column;
                int x = 9 + 20 * column;
                int y = 17 + 22 * row;
                this.addWidget((Widget)new EntryButtonWidget(x, y, 20, 22, () -> this.getEntry(index), () -> ((BaseChiselingContainer)this.container).currentEntry, () -> this.selectEntry(index), () -> ((BaseChiselingContainer)this.container).connecting));
            }
        }
        this.addWidget((Widget)new EntryPreviewWidget(117, 17, 68, 69, () -> {
            ChiselingEntry entry = ((BaseChiselingContainer)this.container).currentEntry;
            if (entry == null) {
                return null;
            }
            return ((BaseChiselingContainer)this.container).connecting && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
        }, () -> previewMode));
        Supplier<Boolean> enablePreviewButtons = () -> {
            ChiselingEntry entry = ((BaseChiselingContainer)this.container).currentEntry;
            if (entry == null) {
                return false;
            }
            Item currentItem = ((BaseChiselingContainer)this.container).connecting && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
            return currentItem instanceof BlockItem;
        };
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 18, 19, 21, 2, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 2;
        }));
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 41, 19, 21, 1, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 1;
        }));
        this.addWidget((Widget)new PreviewModeButtonWidget(193, 64, 19, 21, 0, () -> previewMode, enablePreviewButtons, () -> {
            previewMode = 0;
        }));
        this.addWidget((Widget)new ConnectingToggleWidget(193, 99, 19, 21, () -> ((BaseChiselingContainer)this.container).connecting, () -> ((BaseChiselingContainer)this.container).currentEntry, this::toggleConnecting));
        this.chiselAllWidget = (ChiselAllWidget)this.addWidget((Widget)new ChiselAllWidget(127, 99, 19, 21, () -> ((BaseChiselingContainer)this.container).currentEntry, this::chiselAll));
    }

    public ITextComponent getNarrationMessage() {
        return this.title;
    }

    public void renderBackground(MatrixStack poseStack, int mouseX, int mouseY) {
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((MatrixStack)poseStack, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height);
        super.renderBackground(poseStack, mouseX, mouseY);
    }

    public void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (((BaseChiselingContainer)this.container).currentRecipe != null && this.chiselAllWidget != null && this.chiselAllWidget.isFocused()) {
            for (int index = 1; index < ((BaseChiselingContainer)this.container).field_75151_b.size(); ++index) {
                Slot slot = ((BaseChiselingContainer)this.container).func_75139_a(index);
                ItemStack stack = slot.func_75211_c();
                for (ChiselingEntry entry : ((BaseChiselingContainer)this.container).currentRecipe.getEntries()) {
                    if (stack.func_77942_o() && !stack.func_77978_p().isEmpty() || (!entry.hasConnectingItem() || stack.func_77973_b() != entry.getConnectingItem()) && (!entry.hasRegularItem() || stack.func_77973_b() != entry.getRegularItem())) continue;
                    ScreenUtils.fillRect((MatrixStack)matrixStack, (float)slot.field_75223_e, (float)slot.field_75221_f, (float)16.0f, (float)16.0f, (float)0.0f, (float)20.0f, (float)100.0f, (float)0.5f);
                }
            }
        }
        super.renderForeground(matrixStack, mouseX, mouseY);
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)ClientUtils.getPlayer().field_71071_by.func_200200_C_(), (float)31.0f, (float)133.0f);
    }

    private ChiselingEntry getEntry(int index) {
        ChiselingRecipe recipe = ((BaseChiselingContainer)this.container).currentRecipe;
        if (recipe == null) {
            return null;
        }
        return index >= 0 && index < recipe.getEntries().size() ? recipe.getEntries().get(index) : null;
    }

    private void selectEntry(int index) {
        Rechiseled.CHANNEL.sendToServer((BasePacket)new PacketSelectEntry(index));
    }

    private void toggleConnecting() {
        Rechiseled.CHANNEL.sendToServer((BasePacket)new PacketToggleConnecting());
    }

    private void chiselAll() {
        Rechiseled.CHANNEL.sendToServer((BasePacket)new PacketChiselAll());
    }
}

