/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class ConnectingToggleWidget
extends AbstractButtonWidget {
    private static final ResourceLocation GREY_BUTTONS = new ResourceLocation("rechiseled", "textures/screen/grey_buttons.png");
    private static final ResourceLocation ICON_CONNECTED_ON = new ResourceLocation("rechiseled", "textures/screen/icon_connecting_true.png");
    private static final ResourceLocation ICON_CONNECTED_OFF = new ResourceLocation("rechiseled", "textures/screen/icon_connecting_false.png");
    private final Supplier<Boolean> connecting;
    private final Supplier<ChiselingEntry> currentEntry;

    public ConnectingToggleWidget(int x, int y, int width, int height, Supplier<Boolean> connecting, Supplier<ChiselingEntry> currentEntry, Runnable onPress) {
        super(x, y, width, height, onPress);
        this.connecting = connecting;
        this.currentEntry = currentEntry;
    }

    public ITextComponent getNarrationMessage() {
        Holder message = new Holder();
        this.getTooltips(arg_0 -> ((Holder)message).set(arg_0));
        return (ITextComponent)message.get();
    }

    protected void getTooltips(Consumer<ITextComponent> tooltips) {
        boolean connecting = this.connecting.get();
        ChiselingEntry currentEntry = this.currentEntry.get();
        if (currentEntry != null && (connecting ? currentEntry.hasRegularItem() : currentEntry.hasConnectingItem())) {
            tooltips.accept((ITextComponent)TextComponents.translation((String)"rechiseled.chiseling.connecting", (Object[])new Object[]{TextComponents.translation((String)("rechiseled.chiseling.connecting." + (connecting ? "on" : "off"))).color(TextFormatting.GOLD).get()}).get());
        }
    }

    public void render(MatrixStack poseStack, int mouseX, int mouseY) {
        boolean connecting = this.connecting.get();
        ChiselingEntry currentEntry = this.currentEntry.get();
        boolean canSwitch = currentEntry != null && (connecting ? currentEntry.hasRegularItem() : currentEntry.hasConnectingItem());
        ScreenUtils.bindTexture((ResourceLocation)GREY_BUTTONS);
        ScreenUtils.drawTexture((MatrixStack)poseStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.0f, (float)((float)(canSwitch ? (this.isFocused() ? 2 : 0) : 1) / 3.0f), (float)1.0f, (float)0.33333334f);
        GlStateManager.func_227709_e_();
        ScreenUtils.bindTexture((ResourceLocation)(this.connecting.get() != false ? ICON_CONNECTED_ON : ICON_CONNECTED_OFF));
        ScreenUtils.drawTexture((MatrixStack)poseStack, (float)(this.x + 1), (float)(this.y + 2), (float)(this.width - 2), (float)(this.height - 4));
    }
}

