/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.rechiseled.screen.BlockCapture;
import com.supermartijn642.rechiseled.screen.BlockCaptureLevel;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ScreenBlockRenderer {
    private static final MatrixStack POSE_STACK = new MatrixStack();
    private static BlockCaptureLevel fakeLevel;

    public static void drawBlock(BlockCapture capture, double x, double y, double scale, float yaw, float pitch, boolean doShading) {
        AxisAlignedBB bounds = capture.getBounds();
        double span = Math.sqrt(bounds.func_216364_b() * bounds.func_216364_b() + bounds.func_216360_c() * bounds.func_216360_c() + bounds.func_216362_d() * bounds.func_216362_d());
        scale /= span;
        if (fakeLevel == null) {
            fakeLevel = new BlockCaptureLevel();
        }
        fakeLevel.setCapture(capture);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)350.0);
        RenderSystem.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        POSE_STACK.func_227860_a_();
        POSE_STACK.func_227863_a_(new Quaternion(pitch, yaw, 0.0f, true));
        if (doShading) {
            RenderSystem.enableLighting();
        }
        IRenderTypeBuffer.Impl renderTypeBuffer = RenderUtils.getMainBufferSource();
        for (Map.Entry<BlockPos, BlockState> entry : capture.getBlocks()) {
            ScreenBlockRenderer.renderBlock(entry.getKey(), entry.getValue(), POSE_STACK, (IRenderTypeBuffer)renderTypeBuffer);
        }
        renderTypeBuffer.func_228461_a_();
        RenderSystem.enableDepthTest();
        if (doShading) {
            RenderSystem.disableLighting();
        }
        POSE_STACK.func_227865_b_();
        RenderSystem.popMatrix();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        fakeLevel.setCapture(null);
    }

    private static void renderBlock(BlockPos pos, BlockState state, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)pos.func_177958_n() - 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() - 0.5);
        IBakedModel model = ClientUtils.getBlockRenderer().func_184389_a(state);
        IModelData modelData = model.getModelData((IBlockDisplayReader)fakeLevel, pos, state, (IModelData)EmptyModelData.INSTANCE);
        RenderType renderType = RenderTypeLookup.func_239220_a_((BlockState)state, (boolean)true);
        ScreenBlockRenderer.renderModel(model, state, matrixStack, renderTypeBuffer.getBuffer(renderType), modelData);
        matrixStack.func_227865_b_();
    }

    private static void renderModel(IBakedModel modelIn, BlockState state, MatrixStack matrixStackIn, IVertexBuilder bufferIn, IModelData modelData) {
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            ScreenBlockRenderer.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, direction, random, modelData));
        }
        random.setSeed(42L);
        ScreenBlockRenderer.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, null, random, modelData));
    }

    private static void renderQuads(MatrixStack matrixStackIn, IVertexBuilder bufferIn, List<BakedQuad> quadsIn) {
        MatrixStack.Entry matrix = matrixStackIn.func_227866_c_();
        for (BakedQuad bakedquad : quadsIn) {
            bufferIn.addVertexData(matrix, bakedquad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.field_229196_a_, false);
        }
    }
}

