/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class DynamicStackHandler
extends ItemStackHandler
implements IDynamicStackHandler {
    protected NonNullList<ItemStack> previousStacks;

    public DynamicStackHandler(int size) {
        super(size);
        this.previousStacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void setPreviousStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.previousStacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    @Override
    public int getSlots() {
        return this.stacks.size();
    }

    @Override
    @Nonnull
    public ItemStack getPreviousStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.previousStacks.get(slot);
    }

    @Override
    public void grow(int amount) {
        this.stacks = DynamicStackHandler.getResizedList(this.stacks.size() + amount, (NonNullList<ItemStack>)this.stacks);
        this.previousStacks = DynamicStackHandler.getResizedList(this.previousStacks.size() + amount, this.previousStacks);
    }

    @Override
    public void shrink(int amount) {
        this.stacks = DynamicStackHandler.getResizedList(this.stacks.size() - amount, (NonNullList<ItemStack>)this.stacks);
        this.previousStacks = DynamicStackHandler.getResizedList(this.previousStacks.size() - amount, this.previousStacks);
    }

    private static NonNullList<ItemStack> getResizedList(int size, NonNullList<ItemStack> stacks) {
        NonNullList newList = NonNullList.func_191197_a((int)Math.max(0, size), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < newList.size() && i < stacks.size(); ++i) {
            newList.set(i, (Object)((ItemStack)stacks.get(i)));
        }
        return newList;
    }
}

