/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server.sync;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.inventory.CurioStacksHandler;

public class SPacketSyncCurios {
    private int entityId;
    private int entrySize;
    private Map<String, CompoundNBT> map;

    public SPacketSyncCurios(int entityId, Map<String, ICurioStacksHandler> map) {
        LinkedHashMap<String, CompoundNBT> result = new LinkedHashMap<String, CompoundNBT>();
        for (Map.Entry<String, ICurioStacksHandler> entry : map.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getSyncTag());
        }
        this.entityId = entityId;
        this.entrySize = map.size();
        this.map = result;
    }

    public SPacketSyncCurios(Map<String, CompoundNBT> map, int entityId) {
        this.entityId = entityId;
        this.entrySize = map.size();
        this.map = map;
    }

    public static void encode(SPacketSyncCurios msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.writeInt(msg.entrySize);
        for (Map.Entry<String, CompoundNBT> entry : msg.map.entrySet()) {
            buf.func_180714_a(entry.getKey());
            buf.func_150786_a(entry.getValue());
        }
    }

    public static SPacketSyncCurios decode(PacketBuffer buf) {
        int entityId = buf.readInt();
        int entrySize = buf.readInt();
        LinkedHashMap<String, CompoundNBT> map = new LinkedHashMap<String, CompoundNBT>();
        for (int i = 0; i < entrySize; ++i) {
            String key = buf.func_150789_c(25);
            map.put(key, buf.func_150793_b());
        }
        return new SPacketSyncCurios(map, entityId);
    }

    public static void handle(SPacketSyncCurios msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (entity = world.func_73045_a(msg.entityId)) instanceof LivingEntity) {
                CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)entity).ifPresent(handler -> {
                    LinkedHashMap<String, ICurioStacksHandler> stacks = new LinkedHashMap<String, ICurioStacksHandler>();
                    for (Map.Entry<String, CompoundNBT> entry : msg.map.entrySet()) {
                        CurioStacksHandler stacksHandler = new CurioStacksHandler((ICuriosItemHandler)handler, entry.getKey());
                        stacksHandler.applySyncTag(entry.getValue());
                        stacks.put(entry.getKey(), stacksHandler);
                    }
                    handler.setCurios(stacks);
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

