/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.fml.RegistryObject;

public class MGUBlockReg<B extends Block, I extends Item, T extends TileEntity>
implements Supplier<B> {
    private String name;
    private RegistryObject<B> block;
    private RegistryObject<I> item;
    private RegistryObject<TileEntityType<T>> tile;

    @Override
    public B get() {
        return (B)((Block)this.block.get());
    }

    public String getName() {
        return this.name;
    }

    public MGUBlockReg(String name, Supplier<B> blockSupplier, Function<B, I> itemSupplier, Supplier<T> tileSupplier) {
        this.name = name;
        this.block = ModBlocks.BLOCKS.register(name, blockSupplier);
        this.item = ModItems.ITEMS.register(name, () -> (Item)itemSupplier.apply(this.block.get()));
        this.tile = ModBlocks.TILE_ENTITIES.register(name, () -> TileEntityType.Builder.func_223042_a((Supplier)tileSupplier, (Block[])new Block[]{(Block)this.block.get()}).func_206865_a(null));
    }

    public MGUBlockReg(String name, Supplier<B> blockSupplier, Function<B, I> itemSupplier) {
        this.name = name;
        this.block = ModBlocks.BLOCKS.register(name, blockSupplier);
        this.item = ModItems.ITEMS.register(name, () -> (Item)itemSupplier.apply(this.block.get()));
    }

    @Nonnull
    public B getBlock() {
        return (B)((Block)this.block.get());
    }

    @Nonnull
    public I getItem() {
        return (I)((Item)this.item.get());
    }

    @Nonnull
    public TileEntityType<T> getTileEntityType() {
        return (TileEntityType)Objects.requireNonNull(this.tile).get();
    }
}

