/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import javax.annotation.Nullable;
import mob_grinding_utils.tile.TileEntityXPSolidifier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockXPSolidifier
extends ContainerBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BlockXPSolidifier(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityXPSolidifier();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_195992_f().func_176734_d();
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction);
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntityXPSolidifier tile;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (tile = (TileEntityXPSolidifier)world.func_175625_s(pos)) != null) {
            CompoundNBT nbt = new CompoundNBT();
            tile.func_189515_b(nbt);
            ItemStack stack = new ItemStack((IItemProvider)Item.func_150898_a((Block)this), 1);
            if (tile.tank.getFluidAmount() > 0) {
                stack.func_77982_d(nbt);
            }
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            if (!tile.inputSlots.getStackInSlot(0).func_190926_b()) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)tile.inputSlots.getStackInSlot(0));
            }
            if (!tile.inputSlots.getStackInSlot(1).func_190926_b()) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)tile.inputSlots.getStackInSlot(1));
            }
            if (!tile.outputSlot.getStackInSlot(0).func_190926_b()) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)tile.outputSlot.getStackInSlot(0));
            }
            world.func_175713_t(pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.field_72995_K && stack.func_77942_o() && (tileentity = world.func_175625_s(pos)) instanceof TileEntityXPSolidifier && !stack.func_77978_p().func_74764_b("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)stack.func_77978_p());
            ((TileEntityXPSolidifier)tileentity).tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityXPSolidifier) {
            if (!player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() instanceof BucketItem) {
                LazyOptional fluidHandler = tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.func_216354_b());
                fluidHandler.ifPresent(handler -> {
                    if (player.func_184586_b(hand).func_190926_b() && !handler.getFluidInTank(0).isEmpty()) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent(handler.getFluidInTank(0).getDisplayName().getString() + ": " + handler.getFluidInTank(0).getAmount() + "/" + handler.getTankCapacity(0)), true);
                    } else {
                        FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (World)world, (BlockPos)pos, (Direction)hit.func_216354_b());
                    }
                });
                return ActionResultType.SUCCESS;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((TileEntityXPSolidifier)tileentity), (BlockPos)pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

