/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.models.ModelAHConnect;
import mob_grinding_utils.tile.TileEntityAbsorptionHopper;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityAbsorptionRenderer
extends TileEntityRenderer<TileEntityAbsorptionHopper> {
    private static final ResourceLocation ITEM_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/absorption_hopper_connects_items.png");
    private static final ResourceLocation FLUID_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/absorption_hopper_connects_fluids.png");
    private final ModelAHConnect connectionModel = new ModelAHConnect();

    public TileEntityAbsorptionRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityAbsorptionHopper tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (tile == null || !tile.func_145830_o()) {
            return;
        }
        BlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state == null || state.func_177230_c() != ModBlocks.ABSORPTION_HOPPER.getBlock()) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        for (Direction facing : Direction.values()) {
            if (tile.status[facing.ordinal()] == TileEntityAbsorptionHopper.EnumStatus.STATUS_OUTPUT_ITEM) {
                matrixStack.func_227860_a_();
                this.getRotTranslation(matrixStack, facing);
                this.connectionModel.func_225598_a_(matrixStack, buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)ITEM_TEXTURE)), combinedLight, OverlayTexture.field_229196_a_, 0.5f, 0.5f, 0.5f, 1.0f);
                matrixStack.func_227865_b_();
            }
            if (tile.status[facing.ordinal()] != TileEntityAbsorptionHopper.EnumStatus.STATUS_OUTPUT_FLUID) continue;
            matrixStack.func_227860_a_();
            this.getRotTranslation(matrixStack, facing);
            this.connectionModel.func_225598_a_(matrixStack, buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)FLUID_TEXTURE)), combinedLight, OverlayTexture.field_229196_a_, 0.5f, 0.5f, 0.5f, 1.0f);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
        if (!tile.showRenderBox) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-5.0E-4, -5.0E-4, -5.0E-4);
        matrixStack.func_227862_a_(0.999f, 0.999f, 0.999f);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)buffer.getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)tile.getAABBForRender(), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        matrixStack.func_227865_b_();
    }

    public void getRotTranslation(MatrixStack matrixStack, Direction facing) {
        switch (facing) {
            case UP: {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
                break;
            }
            case DOWN: {
                break;
            }
            case NORTH: {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                break;
            }
            case SOUTH: {
                matrixStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(90.0f));
                break;
            }
            case WEST: {
                matrixStack.func_227863_a_(Vector3f.field_229182_e_.func_229187_a_(90.0f));
                break;
            }
            case EAST: {
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            }
        }
    }
}

