/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.blocks.BlockXPSolidifier;
import mob_grinding_utils.models.ModelXPSolidifier;
import mob_grinding_utils.tile.TileEntityXPSolidifier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityXPSolidifierRenderer
extends TileEntityRenderer<TileEntityXPSolidifier> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/xp_solidifier.png");
    private static final ResourceLocation TEXTURE_NO_PUSH = new ResourceLocation("mob_grinding_utils:textures/tiles/xp_solidifier_no_push.png");
    private final ModelXPSolidifier xp_solidifier_model = new ModelXPSolidifier();

    public TileEntityXPSolidifierRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityXPSolidifier tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLight, int combinedOverlay) {
        if (tile == null || !tile.func_145830_o()) {
            return;
        }
        BlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state == null || state.func_177230_c() != ModBlocks.XPSOLIDIFIER.getBlock()) {
            return;
        }
        Direction facing = (Direction)state.func_177229_b((Property)BlockXPSolidifier.FACING);
        float ticks = (float)tile.prevAnimationTicks + (float)(tile.animationTicks - tile.prevAnimationTicks) * partialTicks;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.5, 0.5);
        matrixStack.func_227862_a_(-0.9999f, -0.9999f, 0.9999f);
        switch (tile.outputDirection) {
            case NONE: 
            case NORTH: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                break;
            }
            case SOUTH: {
                matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(90.0f));
                break;
            }
            case WEST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(0.0f));
                break;
            }
            case EAST: {
                matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(180.0f));
                break;
            }
            default: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.xp_solidifier_model.renderExport(matrixStack, bufferIn.getBuffer(RenderType.func_228646_f_((ResourceLocation)(tile.outputDirection == TileEntityXPSolidifier.OutputDirection.NONE ? TEXTURE_NO_PUSH : TEXTURE))), combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 1.5, 0.5);
        matrixStack.func_227862_a_(-0.9999f, -0.9999f, 0.9999f);
        switch (facing) {
            case NORTH: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(0.0f));
                break;
            }
            case SOUTH: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                break;
            }
            case WEST: {
                matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(90.0f));
                break;
            }
            case EAST: {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                break;
            }
        }
        matrixStack.func_227860_a_();
        RenderSystem.enableBlend();
        if (ticks > 0.0f && ticks <= 20.0f) {
            matrixStack.func_227861_a_(0.0, (double)(ticks * 0.009375f), 0.0);
        }
        if (ticks > 20.0f && ticks <= 60.0f) {
            matrixStack.func_227861_a_(0.0, 0.1875, 0.0);
        }
        if (ticks > 60.0f && ticks <= 80.0f) {
            matrixStack.func_227861_a_(0.0, (double)((80.0f - ticks) * 0.009375f), 0.0);
        }
        if (ticks > 80.0f || ticks <= 0.0f) {
            matrixStack.func_227861_a_(0.0, 0.0, 0.0);
        }
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.xp_solidifier_model.renderRack(matrixStack, bufferIn.getBuffer(RenderType.func_228646_f_((ResourceLocation)TEXTURE)), combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.60625, -0.22);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227862_a_(1.25f, 1.25f, 1.25f);
        ItemStack stackMould = tile.inputSlots.getStackInSlot(0);
        if (!stackMould.func_190926_b()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
            Minecraft.func_71410_x().func_175599_af().func_229111_a_(stackMould, ItemCameraTransforms.TransformType.GROUND, false, matrixStack, bufferIn, combinedLight, combinedOverlay, Minecraft.func_71410_x().func_175599_af().func_184393_a(stackMould, null, null));
        }
        matrixStack.func_227865_b_();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.func_227865_b_();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.xp_solidifier_model.func_225598_a_(matrixStack, bufferIn.getBuffer(RenderType.func_228646_f_((ResourceLocation)TEXTURE)), combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.79375, -0.22);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227862_a_(1.25f, 1.25f, 1.25f);
        ItemStack stackResult = tile.outputSlot.getStackInSlot(0);
        if (stackResult.func_190926_b() && !tile.getCachedOutPutRenderStack().func_190926_b() && tile.getProgress() > 60) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
            Minecraft.func_71410_x().func_175599_af().func_229111_a_(tile.getCachedOutPutRenderStack(), ItemCameraTransforms.TransformType.GROUND, false, matrixStack, bufferIn, combinedLight, combinedOverlay, Minecraft.func_71410_x().func_175599_af().func_184393_a(tile.getCachedOutPutRenderStack(), null, null));
        } else if (!stackResult.func_190926_b()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
            Minecraft.func_71410_x().func_175599_af().func_229111_a_(stackResult, ItemCameraTransforms.TransformType.GROUND, false, matrixStack, bufferIn, combinedLight, combinedOverlay, Minecraft.func_71410_x().func_175599_af().func_184393_a(stackResult, null, null));
        }
        matrixStack.func_227865_b_();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.func_227865_b_();
        if (tile.tank.getFluid().isEmpty()) {
            return;
        }
        float fluidLevel = tile.tank.getFluidAmount();
        if (fluidLevel < 1.0f) {
            return;
        }
        FluidStack fluidStack = new FluidStack(tile.tank.getFluid(), 100);
        float height = 0.46875f / (float)tile.tank.getCapacity() * (float)tile.tank.getFluidAmount();
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStack.getFluid().getAttributes().getStillTexture());
        IVertexBuilder buffer = bufferIn.getBuffer(RenderType.func_228645_f_());
        int fluidColor = fluidStack.getFluid().getAttributes().getColor();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 0.0);
        float yMin = 0.0f;
        float xMax = 1.984375f;
        float zMax = 1.984375f;
        float xMin = 0.015625f;
        float zMin = 0.015625f;
        yMin = 0.015625f;
        float alpha = 1.0f;
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        this.renderCuboid(buffer, matrixStack, xMax, xMin, yMin, height, zMin, zMax, fluidStillSprite, red, green, blue, alpha, combinedLight);
        matrixStack.func_227865_b_();
        if (ticks > 20.0f && ticks < 60.0f && !stackMould.func_190926_b()) {
            matrixStack.func_227860_a_();
            switch (facing) {
                case NORTH: {
                    matrixStack.func_227861_a_(0.0, 0.0, 0.0);
                    break;
                }
                case SOUTH: {
                    matrixStack.func_227861_a_(0.0, 0.0, 0.125);
                    break;
                }
                case WEST: {
                    matrixStack.func_227861_a_(-0.0625, 0.0, 0.0625);
                    break;
                }
                case EAST: {
                    matrixStack.func_227861_a_(0.0625, 0.0, 0.0625);
                    break;
                }
            }
            xMax = 1.62f;
            zMax = 1.5f;
            xMin = 0.38f;
            zMin = 0.25f;
            yMin = 0.6875f;
            this.renderCuboid(buffer, matrixStack, xMax, xMin, yMin, 0.6875f + ticks * 6.25E-4f, zMin, zMax, fluidStillSprite, red, green, blue, alpha, combinedLight);
            matrixStack.func_227865_b_();
        }
    }

    private void renderCuboid(IVertexBuilder buffer, MatrixStack matrixStack, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite, float red, float green, float blue, float alpha, int combinedLight) {
        float uMin = textureAtlasSprite.func_94209_e();
        float uMax = textureAtlasSprite.func_94212_f();
        float vMin = textureAtlasSprite.func_94206_g();
        float vMax = textureAtlasSprite.func_94210_h();
        float vHeight = vMax - vMin;
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMax, red, green, blue, alpha, combinedLight);
    }

    private void addVertexWithUV(IVertexBuilder buffer, MatrixStack matrixStack, float x, float y, float z, float u, float v, float red, float green, float blue, float alpha, int combinedLight) {
        buffer.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), x / 2.0f, y, z / 2.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(u, v).func_225587_b_(combinedLight, 240).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
    }
}

