/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.network;

import java.util.function.Supplier;
import mob_grinding_utils.tile.TileEntityMGUSpawner;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageEntitySpawner {
    public RegistryKey<World> dimension;
    public int entityID;
    public int buttonID;
    public BlockPos tilePos;

    public MessageEntitySpawner(PlayerEntity player, int button, BlockPos pos) {
        this.dimension = player.func_130014_f_().func_234923_W_();
        this.entityID = player.func_145782_y();
        this.buttonID = button;
        this.tilePos = pos;
    }

    public MessageEntitySpawner(PlayerEntity player, int button, int x, int y, int z) {
        this.dimension = player.func_130014_f_().func_234923_W_();
        this.entityID = player.func_145782_y();
        this.buttonID = button;
        this.tilePos = new BlockPos(x, y, z);
    }

    public MessageEntitySpawner(ResourceLocation dimensionKey, int entityID, int buttonID, BlockPos tilePos) {
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimensionKey);
        this.entityID = entityID;
        this.buttonID = buttonID;
        this.tilePos = tilePos;
    }

    public static void encode(MessageEntitySpawner message, PacketBuffer buf) {
        buf.func_192572_a(message.dimension.func_240901_a_());
        buf.writeInt(message.entityID);
        buf.writeInt(message.buttonID);
        buf.func_179255_a(message.tilePos);
    }

    public static MessageEntitySpawner decode(PacketBuffer buf) {
        return new MessageEntitySpawner(buf.func_192575_l(), buf.readInt(), buf.readInt(), buf.func_179259_c());
    }

    public static void handle(MessageEntitySpawner message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntityMGUSpawner spawner;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerWorld world = player.func_184102_h().func_71218_a(message.dimension);
            if (world != null && !world.field_72995_K && player.func_145782_y() == message.entityID && (spawner = (TileEntityMGUSpawner)world.func_175625_s(message.tilePos)) != null) {
                if (message.buttonID == 0) {
                    spawner.toggleRenderBox();
                }
                if (message.buttonID > 0 && message.buttonID <= 6) {
                    spawner.toggleOffset(message.buttonID);
                }
                BlockState state = world.func_180495_p(message.tilePos);
                world.func_184138_a(message.tilePos, state, state, 3);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

