/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.network;

import java.util.function.Supplier;
import mob_grinding_utils.tile.TileEntityXPSolidifier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageSolidifier {
    public int buttonID;
    public BlockPos tilePos;

    public MessageSolidifier(int button, BlockPos pos) {
        this.buttonID = button;
        this.tilePos = pos;
    }

    public MessageSolidifier(int button, int x, int y, int z) {
        this.buttonID = button;
        this.tilePos = new BlockPos(x, y, z);
    }

    public static void encode(MessageSolidifier message, PacketBuffer buf) {
        buf.writeInt(message.buttonID);
        buf.func_179255_a(message.tilePos);
    }

    public static MessageSolidifier decode(PacketBuffer buf) {
        return new MessageSolidifier(buf.readInt(), buf.func_179259_c());
    }

    public static void handle(MessageSolidifier message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerWorld world = player.func_71121_q();
            TileEntityXPSolidifier solidifier = (TileEntityXPSolidifier)world.func_175625_s(message.tilePos);
            if (solidifier != null) {
                if (message.buttonID == 0) {
                    solidifier.toggleOutput();
                }
                if (message.buttonID == 1) {
                    solidifier.toggleOnOff();
                }
                BlockState state = world.func_180495_p(message.tilePos);
                world.func_184138_a(message.tilePos, state, state, 3);
            }
        });
    }
}

