/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.config.parser;

import codechicken.lib.config.ConfigTag;
import codechicken.lib.config.ConfigTagImpl;
import codechicken.lib.config.parser.ConfigFile;
import codechicken.lib.config.parser.ConfigSerializer;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbstractConfigFile
implements ConfigFile {
    private static final Logger logger = LogManager.getLogger();
    private final Path file;
    private final ConfigSerializer serializer;
    private final ConfigTagImpl rootTag;
    private boolean didError = false;

    protected AbstractConfigFile(Path file, ConfigSerializer serializer) {
        this.file = file;
        this.serializer = serializer;
        this.rootTag = new ConfigTagImpl(this, file.getFileName().toString(), null);
    }

    @Override
    public ConfigTag deferLoad() {
        return this.rootTag;
    }

    @Override
    public ConfigTag load() {
        if (Files.exists(this.file, new LinkOption[0])) {
            try {
                this.serializer.parse(this.file, this.rootTag);
                return this.rootTag;
            }
            catch (IOException e) {
                this.rootTag.clear();
                this.didError = true;
                Path backupFile = null;
                try {
                    backupFile = AbstractConfigFile.backupFile(this.file);
                }
                catch (IOException ioException) {
                    logger.warn("Failed to backup config file: ", (Throwable)e);
                }
                logger.error("Failed to load config '{}', Backing up config to '{}' and generating a fresh one.", (Object)this.file, (Object)backupFile, (Object)e);
            }
        }
        return this.rootTag;
    }

    @Override
    public void save(ConfigTag tag) {
        try {
            this.serializer.save(this.file, tag);
        }
        catch (IOException e) {
            logger.error("Unable to save config file '{}'.", (Object)this.file, (Object)e);
        }
    }

    @Override
    public boolean didError() {
        return this.didError;
    }

    private static Path backupFile(Path file) throws IOException {
        String fName = file.getFileName().toString();
        int lastDot = fName.lastIndexOf(".");
        if (lastDot != -1) {
            String backupName = fName.substring(0, lastDot) + "-backup-" + TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
            Path backup = file.resolveSibling(backupName + fName.substring(lastDot));
            Files.move(file, backup, new CopyOption[0]);
            return backup;
        }
        return null;
    }
}

