/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ArrayUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class InventoryNBT
implements IInventory {
    protected ItemStack[] items;
    protected CompoundNBT tag;

    public InventoryNBT(int size, CompoundNBT tag) {
        this.tag = tag;
        this.items = new ItemStack[size];
        ArrayUtils.fillArray(this.items, ItemStack.field_190927_a, Objects::isNull);
        this.readNBT();
    }

    private void writeNBT() {
        this.tag.func_218657_a("items", (INBT)InventoryUtils.writeItemStacksToTag(this.items, this.func_70297_j_()));
    }

    private void readNBT() {
        if (this.tag.func_74764_b("items")) {
            InventoryUtils.readItemStacksFromTag(this.items, this.tag.func_150295_c("items", 10));
        }
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public boolean func_191420_l() {
        return ArrayUtils.count(this.items, stack -> !stack.func_190926_b()) <= 0;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return this.items[slot];
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int amount) {
        return InventoryUtils.decrStackSize(this, slot, amount);
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        return InventoryUtils.removeStackFromSlot(this, slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.items[slot] = stack;
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.writeNBT();
    }

    public void func_174888_l() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = ItemStack.field_190927_a;
        }
        this.func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }
}

