/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory;

import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;

public class InventoryRange {
    public IInventory inv;
    public Direction face;
    public ISidedInventory sidedInv;
    public int[] slots;

    @Deprecated
    public InventoryRange(IInventory inv, int side) {
        this(inv, Direction.field_82609_l[side]);
    }

    public InventoryRange(IInventory inv, Direction side) {
        this.inv = inv;
        this.face = side;
        if (inv instanceof ISidedInventory) {
            this.sidedInv = (ISidedInventory)inv;
            this.slots = this.sidedInv.func_180463_a(this.face);
        } else {
            this.slots = new int[inv.func_70302_i_()];
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i] = i;
            }
        }
    }

    public InventoryRange(IInventory inv) {
        this(inv, Direction.DOWN);
    }

    public InventoryRange(IInventory inv, int fslot, int lslot) {
        this.inv = inv;
        this.slots = new int[lslot - fslot];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = fslot + i;
        }
    }

    public InventoryRange(IInventory inv, InventoryRange access) {
        this.inv = inv;
        this.slots = access.slots;
        this.face = access.face;
        if (inv instanceof ISidedInventory) {
            this.sidedInv = (ISidedInventory)inv;
        }
    }

    public boolean canInsertItem(int slot, @Nonnull ItemStack item) {
        return this.sidedInv == null ? this.inv.func_94041_b(slot, item) : this.sidedInv.func_180462_a(slot, item, this.face);
    }

    public boolean canExtractItem(int slot, @Nonnull ItemStack item) {
        return this.sidedInv == null ? this.inv.func_94041_b(slot, item) : this.sidedInv.func_180461_b(slot, item, this.face);
    }

    public int lastSlot() {
        int last = 0;
        for (int slot : this.slots) {
            if (slot <= last) continue;
            last = slot;
        }
        return last;
    }
}

