/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.vec.Vector3;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.SimpleModelTransform;

public class TransformUtils {
    private static final TransformationMatrix flipX = new TransformationMatrix(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
    public static final IModelTransform DEFAULT_BLOCK;
    public static final IModelTransform DEFAULT_ITEM;
    public static final IModelTransform DEFAULT_TOOL;
    public static final IModelTransform DEFAULT_BOW;
    public static final IModelTransform DEFAULT_HANDHELD_ROD;

    public static TransformationMatrix create(float tx, float ty, float tz, float rx, float ry, float rz, float s) {
        return TransformUtils.create(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), new Vector3f(rx, ry, rz), new Vector3f(s, s, s));
    }

    public static TransformationMatrix create(Vector3 transform, Vector3 rotation, Vector3 scale) {
        return TransformUtils.create(transform.vector3f(), rotation.vector3f(), scale.vector3f());
    }

    public static TransformationMatrix create(Vector3f transform, Vector3f rotation, Vector3f scale) {
        return new TransformationMatrix(transform, new Quaternion(rotation.func_195899_a(), rotation.func_195900_b(), rotation.func_195902_c(), true), scale, null);
    }

    public static TransformationMatrix flipLeft(TransformationMatrix transform) {
        return flipX.func_227985_a_(transform).func_227985_a_(flipX);
    }

    static {
        HashMap<ItemCameraTransforms.TransformType, TransformationMatrix> map = new HashMap<ItemCameraTransforms.TransformType, TransformationMatrix>();
        TransformationMatrix thirdPerson = TransformUtils.create(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        map.put(ItemCameraTransforms.TransformType.GUI, TransformUtils.create(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        map.put(ItemCameraTransforms.TransformType.FIXED, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.flipLeft(thirdPerson));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        DEFAULT_BLOCK = new SimpleModelTransform(ImmutableMap.copyOf(map));
        map = new HashMap();
        thirdPerson = TransformUtils.create(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        TransformationMatrix firstPerson = TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.HEAD, TransformUtils.create(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.flipLeft(thirdPerson));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, firstPerson);
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.flipLeft(firstPerson));
        DEFAULT_ITEM = new SimpleModelTransform(ImmutableMap.copyOf(map));
        map = new HashMap();
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.FIXED, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_TOOL = new SimpleModelTransform(ImmutableMap.copyOf(map));
        map = new HashMap();
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.FIXED, TransformUtils.create(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(-1.0f, -2.0f, 2.5f, -80.0f, 260.0f, -40.0f, 0.9f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.create(-1.0f, -2.0f, 2.5f, -80.0f, -280.0f, 40.0f, 0.9f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_BOW = new SimpleModelTransform(ImmutableMap.copyOf(map));
        map = new HashMap();
        map.put(ItemCameraTransforms.TransformType.GROUND, TransformUtils.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 4.0f, 2.5f, 0.0f, 90.0f, 55.0f, 0.85f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 4.0f, 2.5f, 0.0f, -90.0f, -55.0f, 0.85f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TransformUtils.create(0.0f, 1.6f, 0.8f, 0.0f, 90.0f, 25.0f, 0.68f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TransformUtils.create(0.0f, 1.6f, 0.8f, 0.0f, -90.0f, -25.0f, 0.68f));
        DEFAULT_HANDHELD_ROD = new SimpleModelTransform(ImmutableMap.copyOf(map));
    }
}

