/*
 * Decompiled with CFR 0.152.
 */
package com.minttea.minecraft.tomeofblood.common.items;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.MathUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IntangibleAirTile;
import com.hollingsworth.arsnouveau.common.block.tile.PhantomBlockTile;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.minttea.minecraft.tomeofblood.common.items.BloodScroll;
import com.minttea.minecraft.tomeofblood.common.items.BloodSpellResolver;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.common.item.IBindable;

public class BloodGem
extends Item
implements IScribeable,
IBindable {
    public BloodGem() {
        super(new Item.Properties().func_200917_a(64).func_200916_a(ArsNouveau.itemGroup));
    }

    public boolean onScribe(World world, BlockPos blockPos, PlayerEntity player, Hand hand, ItemStack itemStack) {
        ItemStack held = player.func_184586_b(hand);
        if (!(held.func_77973_b() instanceof SpellParchment || held.func_77973_b() instanceof BloodScroll || held.func_77973_b() instanceof SpellBook || held.func_77978_p() == null)) {
            return false;
        }
        Spell spell = new Spell();
        List<AbstractSpellPart> parts = null;
        if (held.func_77973_b() instanceof SpellParchment) {
            parts = SpellParchment.getSpellRecipe((ItemStack)held);
        } else if (held.func_77973_b() instanceof SpellBook) {
            parts = ((SpellBook)held.func_77973_b()).getCurrentRecipe((ItemStack)held).recipe;
        } else if (held.func_77973_b() instanceof BloodScroll) {
            parts = ((BloodScroll)held.func_77973_b()).getCurrentRecipe(held);
        }
        if (parts != null) {
            spell = new Spell((List)parts);
            String spellTag = held.func_77978_p().func_74779_i("spell");
            if (parts.size() + this.getSpell(itemStack).getSpellSize() > 30) {
                PortUtil.sendMessageCenterScreen((Entity)player, (ITextComponent)new StringTextComponent("Spell too complex."));
                return false;
            }
            if (parts.size() == 0) {
                itemStack.func_77978_p().func_74778_a("spell", "");
            } else if (this.getSpell(itemStack).getSpellSize() > 0) {
                if (this.addToSpell(itemStack, spellTag)) {
                    PortUtil.sendMessageCenterScreen((Entity)player, (ITextComponent)new StringTextComponent("Added parts to spell: " + spell.getDisplayString()));
                    return true;
                }
            } else if (this.setSpell(itemStack, spellTag)) {
                PortUtil.sendMessageCenterScreen((Entity)player, (ITextComponent)new StringTextComponent("Set Spell: " + spell.getDisplayString()));
                return true;
            }
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        RayTraceResult result = playerIn.func_213324_a(5.0, 0.0f, false);
        if (result instanceof BlockRayTraceResult && worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a()) instanceof ScribesTile) {
            ScribesTile tile = (ScribesTile)worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a());
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (result instanceof BlockRayTraceResult && !playerIn.func_225608_bj_() && worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a()) != null && !(worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a()) instanceof IntangibleAirTile) && !(worldIn.func_175625_s(((BlockRayTraceResult)result).func_216350_a()) instanceof PhantomBlockTile)) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        BloodSpellResolver resolver = new BloodSpellResolver(new SpellContext(this.getSpell(stack), (LivingEntity)playerIn));
        EntityRayTraceResult entityRes = MathUtil.getLookedAtEntity((LivingEntity)playerIn, (int)25);
        if (resolver.canCast((LivingEntity)playerIn)) {
            if (entityRes != null && entityRes.func_216348_a() instanceof LivingEntity) {
                resolver.onCastOnEntity(stack, (LivingEntity)playerIn, (LivingEntity)entityRes.func_216348_a(), handIn);
                stack.func_190918_g(1);
                return new ActionResult(ActionResultType.CONSUME, (Object)stack);
            }
            if (result instanceof BlockRayTraceResult) {
                ItemUseContext context = new ItemUseContext(playerIn, handIn, (BlockRayTraceResult)result);
                stack.func_190918_g(1);
                resolver.onCastOnBlock(context);
                return new ActionResult(ActionResultType.CONSUME, (Object)stack);
            }
            resolver.onCast(stack, (LivingEntity)playerIn, worldIn);
            stack.func_190918_g(1);
            return new ActionResult(ActionResultType.CONSUME, (Object)stack);
        }
        return new ActionResult(ActionResultType.CONSUME, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
    }

    private boolean setSpell(ItemStack itemStack, String recipe) {
        itemStack.func_77978_p().func_74778_a("spell", recipe);
        return true;
    }

    private Spell getSpell(ItemStack stack) {
        assert (stack.func_77978_p() != null);
        return Spell.deserialize((String)stack.func_77978_p().func_74779_i("spell"));
    }

    private boolean addToSpell(ItemStack itemStack, String recipe) {
        String spellTag = itemStack.func_77978_p().func_74779_i("spell");
        spellTag = spellTag + recipe;
        itemStack.func_77978_p().func_74778_a("spell", spellTag);
        return true;
    }

    public ISpellCaster getSpellCaster(ItemStack stack) {
        return SpellCaster.deserialize((ItemStack)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag p_77624_4_) {
        if (!stack.func_77942_o() || stack.func_77978_p().func_74779_i("spell").equals("")) {
            return;
        }
        Spell spell = Spell.deserialize((String)stack.func_77978_p().func_74779_i("spell"));
        tooltip.add((ITextComponent)new StringTextComponent(spell.getDisplayString()));
    }
}

