/*
 * Decompiled with CFR 0.152.
 */
package com.minttea.minecraft.tomeofblood.common.items;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.minttea.minecraft.tomeofblood.setup.Registries.SpellRegistry;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.soul.ItemSentientSword;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class SentientHarmEffect
extends AbstractEffect {
    public static SentientHarmEffect INSTANCE = new SentientHarmEffect();

    public SentientHarmEffect() {
        super("sentientharm", "Sentient Harm");
    }

    public void onResolve(RayTraceResult rayTraceResult, World world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        if (rayTraceResult instanceof EntityRayTraceResult) {
            PlayerEntity player = (PlayerEntity)spellContext.getCaster();
            EnumDemonWillType type = PlayerDemonWillHandler.getLargestWillType((PlayerEntity)player);
            int souls = (int)PlayerDemonWillHandler.getTotalDemonWill((EnumDemonWillType)type, (PlayerEntity)player);
            int bracket = this.getBracket(type, souls);
            Entity entity = ((EntityRayTraceResult)rayTraceResult).func_216348_a();
            if (entity instanceof LivingEntity) {
                int time = spellStats.getDurationInTicks();
                float damage = (float)((double)(4.0f + 2.0f * this.getExtraDamage(spellContext, type, souls)) + 2.0 * spellStats.getAmpMultiplier());
                ((LivingEntity)entity).func_195064_c(new EffectInstance(BloodMagicPotions.SOUL_SNARE, 300, 0));
                switch (type) {
                    case CORROSIVE: {
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_82731_v, time > 0 ? ItemSentientSword.poisonTime[bracket] * time : ItemSentientSword.poisonTime[bracket], ItemSentientSword.poisonLevel[bracket] + 1));
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DESTRUCTIVE: {
                        break;
                    }
                    case VENGEFUL: {
                        if (!(((LivingEntity)entity).func_110143_aJ() < damage)) break;
                        player.func_195064_c(new EffectInstance((Effect)ModPotions.MANA_REGEN_EFFECT, time > 0 ? ItemSentientSword.absorptionTime[bracket] * time : ItemSentientSword.absorptionTime[bracket], ItemSentientSword.absorptionTime[bracket], false, false));
                        break;
                    }
                    case STEADFAST: {
                        if (!(((LivingEntity)entity).func_110143_aJ() < damage)) break;
                        float absorption = player.func_110139_bj();
                        player.func_195064_c(new EffectInstance(Effects.field_76444_x, time > 0 ? ItemSentientSword.absorptionTime[bracket] * time : ItemSentientSword.absorptionTime[bracket], 127, false, false));
                        player.func_110149_m((float)Math.min((double)(absorption + ((LivingEntity)entity).func_110138_aP() * 0.25f), ItemSentientSword.maxAbsorptionHearts));
                    }
                }
                this.dealDamage(world, shooter, damage, spellStats, entity, this.buildDamageSource(world, shooter).func_82726_p());
            }
        }
    }

    public float getExtraDamage(SpellContext spellContext, EnumDemonWillType type, int souls) {
        int bracket = this.getBracket(type, souls);
        if (bracket < 0) {
            return 0.0f;
        }
        switch (type) {
            case CORROSIVE: 
            case DEFAULT: {
                return (float)ItemSentientSword.defaultDamageAdded[bracket];
            }
            case DESTRUCTIVE: {
                return (float)ItemSentientSword.destructiveDamageAdded[bracket];
            }
            case VENGEFUL: {
                return (float)ItemSentientSword.vengefulDamageAdded[bracket];
            }
            case STEADFAST: {
                return (float)ItemSentientSword.steadfastDamageAdded[bracket];
            }
        }
        return 0.0f;
    }

    public int getBracket(EnumDemonWillType type, int souls) {
        int bracket = -1;
        for (int i = 0; i < ItemSentientSword.soulBracket.length; ++i) {
            if (souls < ItemSentientSword.soulBracket[i]) continue;
            bracket = i;
        }
        return bracket;
    }

    public int getManaCost() {
        return 50;
    }

    @Nullable
    public Item getCraftingReagent() {
        return (Item)BloodMagicItems.SENTIENT_SWORD.get();
    }

    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.TWO;
    }

    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentFortune.INSTANCE});
    }

    public String getBookDescription() {
        return "An advanced spell, that utilizes your collected demonic will to improve your damage output.";
    }

    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellRegistry.BLOODMAGIC});
    }
}

