/*
 * Decompiled with CFR 0.152.
 */
package jeresources.collection;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import jeresources.entry.VillagerEntry;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;

public class TradeList
extends LinkedList<Trade> {
    private static final Random r = new Random();
    private VillagerEntry villagerEntry;

    public TradeList(VillagerEntry villagerEntry) {
        this.villagerEntry = villagerEntry;
    }

    public List<ItemStack> getCostAs() {
        return this.stream().map(Trade::getMinCostA).collect(Collectors.toList());
    }

    public List<ItemStack> getCostBs() {
        return this.stream().map(Trade::getMinCostB).filter(itemStack -> !itemStack.func_190926_b()).collect(Collectors.toList());
    }

    public List<ItemStack> getResults() {
        return this.stream().map(Trade::getMinResult).collect(Collectors.toList());
    }

    public TradeList getSubListSell(ItemStack itemStack) {
        return this.stream().filter(trade -> trade.sellsItem(itemStack)).collect(Collectors.toCollection(() -> new TradeList(this.villagerEntry)));
    }

    public TradeList getSubListBuy(ItemStack itemStack) {
        return this.stream().filter(trade -> trade.buysItem(itemStack)).collect(Collectors.toCollection(() -> new TradeList(this.villagerEntry)));
    }

    public TradeList getFocusedList(IFocus<ItemStack> focus) {
        if (focus == null) {
            return this;
        }
        switch (focus.getMode()) {
            case INPUT: {
                return this.getSubListBuy((ItemStack)focus.getValue());
            }
            case OUTPUT: {
                return this.getSubListSell((ItemStack)focus.getValue());
            }
        }
        return this;
    }

    private void addMerchantRecipe(MerchantOffers merchantOffers, VillagerTrades.ITrade trade, Random rand) {
        MerchantOffer offer = trade.func_221182_a((Entity)this.villagerEntry.getVillagerEntity(), rand);
        if (offer != null) {
            merchantOffers.add((Object)offer);
        }
    }

    public void addITradeList(VillagerTrades.ITrade[] tradeList) {
        for (VillagerTrades.ITrade trade : tradeList) {
            int maxResult;
            int minCostB;
            int maxCostB;
            int maxCostA;
            MerchantOffers tempList = new MerchantOffers();
            Random rand = new Random();
            for (int itr = 0; itr < 100; ++itr) {
                this.addMerchantRecipe(tempList, trade, rand);
            }
            if (tempList.size() == 0) {
                return;
            }
            ItemStack costA = ((MerchantOffer)tempList.get(0)).func_222205_b();
            ItemStack costB = ((MerchantOffer)tempList.get(0)).func_222202_c();
            ItemStack result = ((MerchantOffer)tempList.get(0)).func_222200_d();
            int minCostA = maxCostA = costA.func_190916_E();
            if (!costB.func_190926_b()) {
                minCostB = maxCostB = costB.func_190916_E();
            } else {
                maxCostB = 1;
                minCostB = 1;
            }
            int minResult = maxResult = result.func_190916_E();
            for (MerchantOffer merchantRecipe : tempList) {
                if (minCostA > merchantRecipe.func_222218_a().func_190916_E()) {
                    minCostA = merchantRecipe.func_222205_b().func_190916_E();
                }
                if (!costB.func_190926_b() && minCostB > merchantRecipe.func_222202_c().func_190916_E()) {
                    minCostB = merchantRecipe.func_222202_c().func_190916_E();
                }
                if (minResult > merchantRecipe.func_222200_d().func_190916_E()) {
                    minResult = merchantRecipe.func_222200_d().func_190916_E();
                }
                if (maxCostA < merchantRecipe.func_222205_b().func_190916_E()) {
                    maxCostA = merchantRecipe.func_222205_b().func_190916_E();
                }
                if (!costB.func_190926_b() && maxCostB < merchantRecipe.func_222202_c().func_190916_E()) {
                    maxCostB = merchantRecipe.func_222205_b().func_190916_E();
                }
                if (maxResult >= merchantRecipe.func_222200_d().func_190916_E()) continue;
                maxResult = merchantRecipe.func_222200_d().func_190916_E();
            }
            this.add(new Trade(costA, minCostA, maxCostA, costB, minCostB, maxCostB, result, minResult, maxResult));
        }
    }

    public static class Trade {
        private final ItemStack costA;
        private final ItemStack costB;
        private final ItemStack result;
        private final int minCostA;
        private final int minCostB;
        private final int minResult;
        private final int maxCostA;
        private final int maxCostB;
        private final int maxResult;

        Trade(ItemStack costA, int minCostA, int maxCostA, ItemStack costB, int minCostB, int maxCostB, ItemStack result, int minResult, int maxResult) {
            this.costA = costA;
            this.minCostA = minCostA;
            this.maxCostA = maxCostA;
            this.costB = costB;
            this.minCostB = minCostB;
            this.maxCostB = maxCostB;
            this.result = result;
            this.minResult = minResult;
            this.maxResult = maxResult;
        }

        public boolean sellsItem(ItemStack itemStack) {
            return this.result.func_77969_a(itemStack);
        }

        public boolean buysItem(ItemStack itemStack) {
            return this.costA.func_77969_a(itemStack) || !this.costB.func_190926_b() && this.costB.func_77969_a(itemStack);
        }

        public ItemStack getMinCostA() {
            ItemStack minBuyStack = this.costA.func_77946_l();
            minBuyStack.func_190920_e(this.minCostA);
            return minBuyStack;
        }

        public ItemStack getMinCostB() {
            if (this.costB == null) {
                return ItemStack.field_190927_a;
            }
            ItemStack minBuyStack = this.costB.func_77946_l();
            minBuyStack.func_190920_e(this.minCostB);
            return minBuyStack;
        }

        public ItemStack getMinResult() {
            ItemStack minSellStack = this.result.func_77946_l();
            minSellStack.func_190920_e(this.minResult);
            return minSellStack;
        }

        public ItemStack getMaxCostA() {
            ItemStack maxBuyStack = this.costA.func_77946_l();
            maxBuyStack.func_190920_e(this.maxCostA);
            return maxBuyStack;
        }

        public ItemStack getMaxCostB() {
            if (this.costB == null) {
                return ItemStack.field_190927_a;
            }
            ItemStack maxBuyStack = this.costB.func_77946_l();
            maxBuyStack.func_190920_e(this.maxCostB);
            return maxBuyStack;
        }

        public ItemStack getMaxResult() {
            ItemStack maxSellStack = this.result.func_77946_l();
            maxSellStack.func_190920_e(this.maxResult);
            return maxSellStack;
        }

        public String toString() {
            return "Buy1: " + this.costA + ", Buy2: " + this.costB + ", Sell: " + this.result;
        }
    }
}

