/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.villager;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import jeresources.collection.TradeList;
import jeresources.entry.VillagerEntry;
import jeresources.reference.Resources;
import jeresources.util.Font;
import jeresources.util.RenderHelper;
import jeresources.util.TranslationHelper;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.item.ItemStack;

public class VillagerWrapper
implements IRecipeCategoryExtension {
    private final VillagerEntry entry;
    private IFocus<ItemStack> focus;

    public VillagerWrapper(VillagerEntry entry) {
        this.entry = entry;
    }

    public void setIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.ITEM, this.entry.getInputs());
        ingredients.setOutputs(VanillaTypes.ITEM, this.entry.getOutputs());
    }

    public TradeList getTrades(int level) {
        return this.entry.getVillagerTrades(level);
    }

    public int getMaxLevel() {
        return this.entry.getMaxLevel();
    }

    public List<Integer> getPossibleLevels(IFocus<ItemStack> focus) {
        return this.entry.getPossibleLevels(focus);
    }

    public void setFocus(IFocus<ItemStack> focus) {
        this.focus = focus;
    }

    public void drawInfo(int recipeWidth, int recipeHeight, MatrixStack matrixStack, double mouseX, double mouseY) {
        int i;
        RenderHelper.scissor(matrixStack, 7, 43, 59, 79);
        VillagerEntity entityVillager = this.entry.getVillagerEntity();
        RenderHelper.renderEntity(matrixStack, 37, 118, 36.0, 38.0 - mouseX, 80.0 - mouseY, (LivingEntity)entityVillager);
        RenderHelper.stopScissor();
        int y = 22 * (6 - this.getPossibleLevels(this.focus).size()) / 2;
        for (i = 0; i < this.getPossibleLevels(this.focus).size(); ++i) {
            RenderHelper.drawTexture(matrixStack, 130, y + i * 22, 0, 120, 20, 20, Resources.Gui.Jei.VILLAGER.getResource());
        }
        i = 0;
        for (int level : this.getPossibleLevels(this.focus)) {
            Font.normal.print(matrixStack, "lv. " + (level + 1), 72, y + i++ * 22 + 6);
        }
        Font.normal.print(matrixStack, TranslationHelper.translateAndFormat(this.entry.getDisplayName(), new Object[0]), 10, 25);
    }
}

