/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import com.mojang.datafixers.util.Either;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import jeresources.profiling.EmptyChunkJER;
import jeresources.profiling.ProfilingExecutor;
import jeresources.util.LogHelper;
import net.minecraft.crash.ReportedException;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;

public class ChunkGetter
implements Runnable {
    public static final int CHUNKS_PER_RUN = 25;
    private final int maxRunCount;
    private final Runnable runnable;
    private IChunkGetterStrategy strategy;
    private int runCount;

    public ChunkGetter(final int chunkCount, final ServerWorld world, final ProfilingExecutor executor) {
        this.maxRunCount = (int)Math.ceil((float)chunkCount / 25.0f);
        this.strategy = new ChunkGetterRandom(world);
        this.runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (ChunkGetter.this.getRunCount() < ChunkGetter.this.getMaxRunCount()) {
                        List<IChunk> chunks = ChunkGetter.this.strategy.generateChunks(world);
                        if (ChunkGetter.this.strategy instanceof ChunkGetterRandom && ChunkGetter.this.areAllChunksEmpty(chunks)) {
                            ChunkGetter.this.strategy = new ChunkGetterOrigin(world, chunkCount);
                            chunks = ChunkGetter.this.strategy.generateChunks(world);
                        }
                        ChunkGetter.this.runCount++;
                        executor.addChunkProfiler(world, chunks);
                        executor.execute(() -> world.func_73046_m().func_82010_a(ChunkGetter.this.runnable));
                    } else {
                        executor.shutdown();
                    }
                }
                catch (ReportedException re) {
                    LogHelper.info("Chunk getting failed: " + re.getMessage(), new Object[0]);
                    executor.shutdown();
                }
            }
        };
    }

    @Override
    public void run() {
        this.runnable.run();
    }

    private int getMaxRunCount() {
        return this.maxRunCount;
    }

    private int getRunCount() {
        return this.runCount;
    }

    private boolean areAllChunksEmpty(List<IChunk> chunks) {
        for (IChunk chunk : chunks) {
            if (chunk.func_76625_h() == 0) continue;
            return false;
        }
        return true;
    }

    private static List<IChunk> centerChunks(ServerWorld world, ChunkGenerator chunkGenerator, int chunkX, int chunkZ, int generate_size) {
        LinkedList<IChunk> centerChunks = new LinkedList<IChunk>();
        for (int i = 0; i < generate_size; ++i) {
            for (int j = 0; j < generate_size; ++j) {
                if (i <= 0 || i >= generate_size - 1 || j <= 0 || j >= generate_size - 1) continue;
                centerChunks.add((IChunk)new ChunkPrimerWrapper((Chunk)new EmptyChunkJER((World)world, chunkX + i, chunkZ + j)));
            }
        }
        ChunkStatus.field_222613_i.func_223198_a(world, chunkGenerator, world.func_184163_y(), (ServerWorldLightManager)world.func_225524_e_(), iChunk -> iChunk.func_201589_g().func_209003_a(ChunkStatus.field_222613_i) ? CompletableFuture.completedFuture(Either.left((Object)iChunk)) : ChunkHolder.field_219307_b, centerChunks);
        return centerChunks;
    }

    private static class ChunkGetterOrigin
    implements IChunkGetterStrategy {
        private static final int GENERATE_SIZE = (int)Math.ceil(Math.sqrt(25.0)) + 2;
        private final ChunkGenerator chunkGenerator;
        private final int sideLength;
        private final int minX;
        private final int maxX;
        private int posX;
        private int posZ;

        public ChunkGetterOrigin(ServerWorld world, int chunkCount) {
            this.chunkGenerator = world.func_72863_F().func_201711_g().func_230349_a_(world.field_73012_v.nextLong());
            this.sideLength = (int)Math.ceil(Math.sqrt(chunkCount));
            WorldBorder worldBorder = world.func_175723_af();
            this.minX = (int)worldBorder.func_230316_a_() - this.sideLength / 2;
            this.maxX = (int)worldBorder.func_230316_a_() + this.sideLength / 2;
            this.posX = this.minX;
            this.posZ = (int)worldBorder.func_230317_b_() - this.sideLength / 2;
        }

        @Override
        public List<IChunk> generateChunks(ServerWorld world) {
            int chunkX = this.posX;
            int chunkZ = this.posZ;
            this.posX += GENERATE_SIZE - 1;
            if (this.posX > this.maxX) {
                this.posX = this.minX;
                this.posZ += GENERATE_SIZE - 1;
            }
            return ChunkGetter.centerChunks(world, this.chunkGenerator, chunkX, chunkZ, ChunkGetterOrigin.GENERATE_SIZE);
        }
    }

    private static class ChunkGetterRandom
    implements IChunkGetterStrategy {
        private static final int GENERATE_SIZE = (int)Math.ceil(Math.sqrt(25.0)) + 2;
        private final ChunkGenerator chunkGenerator;

        public ChunkGetterRandom(ServerWorld world) {
            this.chunkGenerator = world.func_72863_F().func_201711_g().func_230349_a_(world.field_73012_v.nextLong());
        }

        @Override
        public List<IChunk> generateChunks(ServerWorld world) {
            WorldBorder worldBorder = world.func_175723_af();
            int maxChunkPos = (int)(worldBorder.func_177741_h() / 16.0) - GENERATE_SIZE;
            int chunkX = world.field_73012_v.nextInt(2 * maxChunkPos) - maxChunkPos + (int)worldBorder.func_230316_a_();
            int chunkZ = world.field_73012_v.nextInt(2 * maxChunkPos) - maxChunkPos + (int)worldBorder.func_230317_b_();
            return ChunkGetter.centerChunks(world, this.chunkGenerator, chunkX, chunkZ, ChunkGetterRandom.GENERATE_SIZE);
        }
    }

    private static interface IChunkGetterStrategy {
        public List<IChunk> generateChunks(ServerWorld var1);
    }
}

