/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.core.helper.ShaderCallback;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.entity.EntityDoppleganger;

public final class BossBarHandler {
    public static final Set<EntityDoppleganger> bosses = Collections.newSetFromMap(new WeakHashMap());
    public static final ResourceLocation defaultBossBar = new ResourceLocation("botania:textures/gui/boss_bar.png");
    private static final BarCallback barUniformCallback = new BarCallback();

    private BossBarHandler() {
    }

    public static void onBarRender(RenderGameOverlayEvent.BossInfo evt) {
        UUID infoUuid = evt.getBossInfo().func_186737_d();
        for (EntityDoppleganger currentBoss : bosses) {
            if (!currentBoss.getBossInfoUuid().equals(infoUuid)) continue;
            MatrixStack ms = evt.getMatrixStack();
            evt.setCanceled(true);
            Minecraft mc = Minecraft.func_71410_x();
            Rectangle2d bgRect = currentBoss.getBossBarTextureRect();
            Rectangle2d fgRect = currentBoss.getBossBarHPTextureRect();
            ITextComponent name = evt.getBossInfo().func_186744_e();
            int c = Minecraft.func_71410_x().func_228018_at_().func_198107_o() / 2;
            int x = evt.getX();
            int y = evt.getY();
            int xf = x + (bgRect.func_199316_c() - fgRect.func_199316_c()) / 2;
            int yf = y + (bgRect.func_199317_d() - fgRect.func_199317_d()) / 2;
            int fw = (int)((double)fgRect.func_199316_c() * (double)evt.getBossInfo().func_186738_f());
            int tx = c - mc.field_71466_p.func_238414_a_((ITextProperties)name) / 2;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int auxHeight = currentBoss.bossBarRenderCallback(ms, x, y);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            mc.field_71446_o.func_110577_a(currentBoss.getBossBarTexture());
            BossBarHandler.drawBar(ms, currentBoss, x, y, bgRect.func_199318_a(), bgRect.func_199319_b(), bgRect.func_199316_c(), bgRect.func_199317_d(), true);
            BossBarHandler.drawBar(ms, currentBoss, xf, yf, fgRect.func_199318_a(), fgRect.func_199319_b(), fw, fgRect.func_199317_d(), false);
            mc.field_71466_p.func_243246_a(ms, name, (float)tx, (float)(y - 10), 10617228);
            RenderSystem.enableBlend();
            int n = Math.max(bgRect.func_199317_d(), fgRect.func_199317_d()) + auxHeight;
            mc.field_71466_p.getClass();
            evt.setIncrement(n + 9);
        }
    }

    private static void drawBar(MatrixStack ms, EntityDoppleganger currentBoss, int x, int y, int u, int v, int w, int h, boolean bg) {
        ShaderHelper.BotaniaShader program = currentBoss.getBossBarShaderProgram(bg);
        if (program != null) {
            ShaderCallback callback = currentBoss.getBossBarShaderCallback(bg);
            barUniformCallback.set(u, v, callback);
            ShaderHelper.useShader(program, barUniformCallback);
        }
        RenderHelper.drawTexturedModalRect(ms, x, y, u, v, w, h);
        if (program != null) {
            ShaderHelper.releaseShader();
        }
    }

    private static class BarCallback
    implements ShaderCallback {
        int x;
        int y;
        ShaderCallback callback;

        private BarCallback() {
        }

        @Override
        public void call(int shader) {
            int startXUniform = GlStateManager.func_227680_b_((int)shader, (CharSequence)"startX");
            int startYUniform = GlStateManager.func_227680_b_((int)shader, (CharSequence)"startY");
            GlStateManager.func_227718_f_((int)startXUniform, (int)this.x);
            GlStateManager.func_227718_f_((int)startYUniform, (int)this.y);
            if (this.callback != null) {
                this.callback.call(shader);
            }
        }

        void set(int x, int y, ShaderCallback callback) {
            this.x = x;
            this.y = y;
            this.callback = callback;
        }
    }
}

