/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.wand.ICoordBoundItem;
import vazkii.botania.api.wand.IWireframeAABBProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.core.handler.ConfigHandler;

public final class BoundTileRenderer {
    private static final IRenderTypeBuffer.Impl LINE_BUFFERS = IRenderTypeBuffer.func_228456_a_((Map)((Map)Util.func_199748_a(() -> {
        IdentityHashMap<RenderType, BufferBuilder> ret = new IdentityHashMap<RenderType, BufferBuilder>();
        ret.put(RenderHelper.LINE_1_NO_DEPTH, new BufferBuilder(RenderHelper.LINE_1_NO_DEPTH.func_228662_o_()));
        ret.put(RenderHelper.LINE_4_NO_DEPTH, new BufferBuilder(RenderHelper.LINE_4_NO_DEPTH.func_228662_o_()));
        ret.put(RenderHelper.LINE_5_NO_DEPTH, new BufferBuilder(RenderHelper.LINE_5_NO_DEPTH.func_228662_o_()));
        ret.put(RenderHelper.LINE_8_NO_DEPTH, new BufferBuilder(RenderHelper.LINE_8_NO_DEPTH.func_228662_o_()));
        return ret;
    })), (BufferBuilder)Tessellator.func_178181_a().func_178180_c());

    private BoundTileRenderer() {
    }

    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        BlockPos coords;
        if (!((Boolean)ConfigHandler.CLIENT.boundBlockWireframe.get()).booleanValue()) {
            return;
        }
        MatrixStack ms = event.getMatrixStack();
        ms.func_227860_a_();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        int color = 0xFF000000 | MathHelper.func_181758_c((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ICoordBoundItem && (coords = ((ICoordBoundItem)player.func_184614_ca().func_77973_b()).getBinding(player.field_70170_p, player.func_184614_ca())) != null) {
            BoundTileRenderer.renderBlockOutlineAt(ms, (IRenderTypeBuffer)LINE_BUFFERS, coords, color);
        }
        if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ICoordBoundItem && (coords = ((ICoordBoundItem)player.func_184592_cb().func_77973_b()).getBinding(player.field_70170_p, player.func_184592_cb())) != null) {
            BoundTileRenderer.renderBlockOutlineAt(ms, (IRenderTypeBuffer)LINE_BUFFERS, coords, color);
        }
        BoundTileRenderer.renderWireframeProviders((IInventory)player.field_71071_by, (PlayerEntity)player, ms, color);
        BoundTileRenderer.renderWireframeProviders(BotaniaAPI.instance().getAccessoriesInventory((PlayerEntity)player), (PlayerEntity)player, ms, color);
        ms.func_227865_b_();
        RenderSystem.disableDepthTest();
        LINE_BUFFERS.func_228461_a_();
    }

    private static void renderWireframeProviders(IInventory inv, PlayerEntity player, MatrixStack ms, int color) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inv.func_70301_a(i);
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof IWireframeCoordinateListProvider)) continue;
            IWireframeCoordinateListProvider provider = (IWireframeCoordinateListProvider)stackInSlot.func_77973_b();
            List<BlockPos> coordsList = provider.getWireframesToDraw(player, stackInSlot);
            for (BlockPos coords : coordsList) {
                BoundTileRenderer.renderBlockOutlineAt(ms, (IRenderTypeBuffer)LINE_BUFFERS, coords, color);
            }
            BlockPos coords = provider.getSourceWireframe(player, stackInSlot);
            if (coords == null || coords.func_177956_o() <= -1) continue;
            BoundTileRenderer.renderBlockOutlineAt(ms, (IRenderTypeBuffer)LINE_BUFFERS, coords, color, true);
        }
    }

    private static void renderBlockOutlineAt(MatrixStack ms, IRenderTypeBuffer buffers, BlockPos pos, int color) {
        BoundTileRenderer.renderBlockOutlineAt(ms, buffers, pos, color, false);
    }

    private static void renderBlockOutlineAt(MatrixStack ms, IRenderTypeBuffer buffers, BlockPos pos, int color, boolean thick) {
        List<Object> list;
        double renderPosX = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82615_a();
        double renderPosY = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82617_b();
        double renderPosZ = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c().func_82616_c();
        ms.func_227860_a_();
        ms.func_227861_a_((double)pos.func_177958_n() - renderPosX, (double)pos.func_177956_o() - renderPosY, (double)pos.func_177952_p() - renderPosZ + 1.0);
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IWireframeAABBProvider) {
            list = ((IWireframeAABBProvider)block).getWireframeAABB((World)world, pos);
        } else {
            VoxelShape shape = state.func_196954_c((IBlockReader)world, pos);
            list = shape.func_197756_d().stream().map(b -> b.func_186670_a(pos)).collect(Collectors.toList());
        }
        if (!list.isEmpty()) {
            ms.func_227862_a_(1.0f, 1.0f, 1.0f);
            IVertexBuilder buffer = buffers.getBuffer(thick ? RenderHelper.LINE_5_NO_DEPTH : RenderHelper.LINE_1_NO_DEPTH);
            for (AxisAlignedBB axisAlignedBB : list) {
                AxisAlignedBB axisAlignedBB2 = axisAlignedBB.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-(pos.func_177952_p() + 1)));
                BoundTileRenderer.renderBlockOutline(ms.func_227866_c_().func_227870_a_(), buffer, axisAlignedBB2, color);
            }
            buffer = buffers.getBuffer(thick ? RenderHelper.LINE_8_NO_DEPTH : RenderHelper.LINE_4_NO_DEPTH);
            int alpha = 64;
            color = color & 0xFFFFFF | alpha << 24;
            for (AxisAlignedBB axisAlignedBB : list) {
                AxisAlignedBB axisAlignedBB3 = axisAlignedBB.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-(pos.func_177952_p() + 1)));
                BoundTileRenderer.renderBlockOutline(ms.func_227866_c_().func_227870_a_(), buffer, axisAlignedBB3, color);
            }
        }
        ms.func_227865_b_();
    }

    private static void renderBlockOutline(Matrix4f mat, IVertexBuilder buffer, AxisAlignedBB aabb, int color) {
        float ix = (float)aabb.field_72340_a;
        float iy = (float)aabb.field_72338_b;
        float iz = (float)aabb.field_72339_c;
        float ax = (float)aabb.field_72336_d;
        float ay = (float)aabb.field_72337_e;
        float az = (float)aabb.field_72334_f;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        buffer.func_227888_a_(mat, ix, iy, iz).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ix, ay, iz).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ix, ay, iz).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ax, ay, iz).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ax, ay, iz).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ax, iy, iz).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ax, iy, iz).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ix, iy, iz).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ix, iy, az).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ix, ay, az).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ix, iy, az).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ax, iy, az).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ax, iy, az).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ax, ay, az).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ix, ay, az).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ax, ay, az).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ix, iy, iz).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ix, iy, az).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ix, ay, iz).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ix, ay, az).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ax, iy, iz).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ax, iy, az).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ax, ay, iz).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(mat, ax, ay, az).func_225586_a_(r, g, b, a).func_181675_d();
    }
}

