/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import vazkii.botania.client.fx.FXLightningBoltPoint;
import vazkii.botania.client.fx.FXLightningSegment;
import vazkii.botania.common.core.helper.Vector3;

public class LightningSegmentGenerator {
    private static final int BRANCH_FACTOR = 2;
    private final Random rand;
    private final Map<Integer, Integer> splitParents = new HashMap<Integer, Integer>();
    private int segmentCount = 1;
    private int splitCount = 0;

    public LightningSegmentGenerator(long seed) {
        this.rand = new Random(seed);
    }

    public Pair<Integer, List<FXLightningSegment>> compute(Vector3 start, Vector3 end, double length) {
        ArrayList<FXLightningSegment> segmentsA = new ArrayList<FXLightningSegment>();
        segmentsA.add(new FXLightningSegment(start, end));
        ArrayList<FXLightningSegment> segmentsB = new ArrayList<FXLightningSegment>();
        this.fractal(segmentsA, segmentsB, length / 1.5, 0.7f, 0.7f, 45.0);
        this.fractal(segmentsB, segmentsA, length / 4.0, 0.5, 0.8f, 50.0);
        this.fractal(segmentsA, segmentsB, length / 15.0, 0.5, 0.9f, 55.0);
        this.fractal(segmentsB, segmentsA, length / 30.0, 0.5, 1.0, 60.0);
        this.fractal(segmentsA, segmentsB, length / 60.0, 0.0, 0.0, 0.0);
        this.fractal(segmentsB, segmentsA, length / 100.0, 0.0, 0.0, 0.0);
        this.fractal(segmentsA, segmentsB, length / 400.0, 0.0, 0.0, 0.0);
        this.calculateCollisionAndDiffs(segmentsB);
        segmentsB.sort((o1, o2) -> Float.compare(o2.light, o1.light));
        return Pair.of((Object)this.segmentCount, segmentsB);
    }

    private void fractal(List<FXLightningSegment> oldSegments, List<FXLightningSegment> outputSegments, double amount, double splitChance, double splitLength, double splitAngle) {
        outputSegments.clear();
        for (FXLightningSegment segment : oldSegments) {
            int i;
            FXLightningSegment prev = segment.prev;
            Vector3 subsegment = segment.diff.multiply(0.5);
            FXLightningBoltPoint[] newpoints = new FXLightningBoltPoint[3];
            Vector3 startpoint = segment.startPoint.point;
            newpoints[0] = segment.startPoint;
            newpoints[2] = segment.endPoint;
            for (i = 1; i < 2; ++i) {
                Vector3 basepoint = startpoint.add(subsegment.multiply(i));
                Vector3 randoff = segment.diff.perpendicular().normalize().rotate(this.rand.nextFloat() * 360.0f, segment.diff).multiply((double)(this.rand.nextFloat() - 0.5f) * amount * 2.0);
                newpoints[i] = new FXLightningBoltPoint(basepoint, randoff);
            }
            for (i = 0; i < 2; ++i) {
                FXLightningSegment next = new FXLightningSegment(newpoints[i], newpoints[i + 1], segment.light, segment.segmentNo * 2 + i, segment.splitNo);
                next.prev = prev;
                if (prev != null) {
                    prev.next = next;
                }
                if (i != 0 && (double)this.rand.nextFloat() < splitChance) {
                    Vector3 splitrot = next.diff.xCrossProduct().rotate(this.rand.nextFloat() * 360.0f, next.diff);
                    Vector3 diff = next.diff.rotate((double)(this.rand.nextFloat() * 0.66f + 0.33f) * splitAngle, splitrot).multiply(splitLength);
                    ++this.splitCount;
                    this.splitParents.put(this.splitCount, next.splitNo);
                    FXLightningSegment split = new FXLightningSegment(newpoints[i], new FXLightningBoltPoint(newpoints[i + 1].basepoint, newpoints[i + 1].offsetvec.add(diff)), segment.light / 2.0f, next.segmentNo, this.splitCount);
                    split.prev = prev;
                    outputSegments.add(split);
                }
                prev = next;
                outputSegments.add(next);
            }
            if (segment.next == null) continue;
            segment.next.prev = prev;
        }
        this.segmentCount *= 2;
    }

    private void calculateCollisionAndDiffs(List<FXLightningSegment> segments) {
        HashMap<Integer, Integer> lastactivesegment = new HashMap<Integer, Integer>();
        segments.sort((o1, o2) -> {
            int comp = Integer.compare(o1.splitNo, o2.splitNo);
            if (comp == 0) {
                return Integer.compare(o1.segmentNo, o2.segmentNo);
            }
            return comp;
        });
        int lastSplitCalc = 0;
        int lastActiveSegment = 0;
        float splitResistance = 0.0f;
        for (FXLightningSegment segment : segments) {
            if (segment.splitNo > lastSplitCalc) {
                lastactivesegment.put(lastSplitCalc, lastActiveSegment);
                lastSplitCalc = segment.splitNo;
                lastActiveSegment = (Integer)lastactivesegment.get(this.splitParents.get(segment.splitNo));
                float f = splitResistance = lastActiveSegment < segment.segmentNo ? 50.0f : 0.0f;
            }
            if (splitResistance >= 40.0f * segment.light) continue;
            splitResistance = this.rayTraceResistance(segment.startPoint.point, segment.endPoint.point, splitResistance);
            lastActiveSegment = segment.segmentNo;
        }
        lastactivesegment.put(lastSplitCalc, lastActiveSegment);
        lastSplitCalc = 0;
        lastActiveSegment = (Integer)lastactivesegment.get(0);
        Iterator<FXLightningSegment> iterator = segments.iterator();
        while (iterator.hasNext()) {
            FXLightningSegment segment;
            segment = iterator.next();
            if (lastSplitCalc != segment.splitNo) {
                lastSplitCalc = segment.splitNo;
                lastActiveSegment = (Integer)lastactivesegment.get(segment.splitNo);
            }
            if (segment.segmentNo > lastActiveSegment) {
                iterator.remove();
            }
            segment.calcEndDiffs();
        }
    }

    private float rayTraceResistance(Vector3 start, Vector3 end, float prevresistance) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        RayTraceContext ctx = new RayTraceContext(start.toVector3d(), end.toVector3d(), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, null);
        BlockRayTraceResult ray = world.func_217299_a(ctx);
        if (ray.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = ray.func_216350_a();
            BlockState state = world.func_180495_p(pos);
            if (state.func_196958_f()) {
                return prevresistance;
            }
            return prevresistance + state.func_177230_c().func_149638_a() + 0.3f;
        }
        return prevresistance;
    }
}

