/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.crafting;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.common.crafting.recipe.AncientWillRecipe;
import vazkii.botania.common.item.ItemAncientWill;
import vazkii.botania.common.item.ModItems;

public class AncientWillRecipeWrapper
implements ICustomCraftingCategoryExtension {
    private final ResourceLocation name;

    public AncientWillRecipeWrapper(AncientWillRecipe recipe) {
        this.name = recipe.func_199560_c();
    }

    public void setIngredients(@Nonnull IIngredients ingredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableList.Builder helmets = ImmutableList.builder();
        ImmutableList.Builder wills = ImmutableList.builder();
        helmets.add((Object)new ItemStack((IItemProvider)ModItems.terrasteelHelm));
        wills.add((Object)new ItemStack((IItemProvider)ModItems.ancientWillAhrim));
        wills.add((Object)new ItemStack((IItemProvider)ModItems.ancientWillDharok));
        wills.add((Object)new ItemStack((IItemProvider)ModItems.ancientWillGuthan));
        wills.add((Object)new ItemStack((IItemProvider)ModItems.ancientWillTorag));
        wills.add((Object)new ItemStack((IItemProvider)ModItems.ancientWillVerac));
        wills.add((Object)new ItemStack((IItemProvider)ModItems.ancientWillKaril));
        builder.add((Object)helmets.build());
        builder.add((Object)wills.build());
        ingredients.setInputLists(VanillaTypes.ITEM, (List)builder.build());
        ingredients.setOutputLists(VanillaTypes.ITEM, (List)ImmutableList.of((Object)helmets.build()));
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IIngredients ingredients) {
        IFocus focus = recipeLayout.getFocus();
        IGuiItemStackGroup group = recipeLayout.getItemStacks();
        group.set(ingredients);
        if (focus != null) {
            ItemStack focused = (ItemStack)focus.getValue();
            if (focus.getMode() == IFocus.Mode.INPUT && focused.func_77973_b() instanceof ItemAncientWill) {
                ItemStack copy = focused.func_77946_l();
                copy.func_190920_e(1);
                group.set(2, copy);
                group.set(0, this.getHelmetsWithWill(((ItemAncientWill)focused.func_77973_b()).type, ingredients));
            } else if (focused.func_77973_b() instanceof IAncientWillContainer) {
                group.set(1, new ItemStack((IItemProvider)focused.func_77973_b()));
                group.set(0, this.getWillsOnHelmet(focused.func_77973_b()));
            }
        }
    }

    private List<ItemStack> getHelmetsWithWill(IAncientWillContainer.AncientWillType type, IIngredients ingredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack itemStack : (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0)) {
            ItemStack toAdd = itemStack.func_77946_l();
            ((IAncientWillContainer)toAdd.func_77973_b()).addAncientWill(toAdd, type);
            builder.add((Object)toAdd);
        }
        return builder.build();
    }

    private List<ItemStack> getWillsOnHelmet(Item item) {
        if (item instanceof IAncientWillContainer) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IAncientWillContainer.AncientWillType type : IAncientWillContainer.AncientWillType.values()) {
                ItemStack stack = new ItemStack((IItemProvider)item);
                ((IAncientWillContainer)item).addAncientWill(stack, type);
                builder.add((Object)stack);
            }
            return builder.build();
        }
        return ImmutableList.of();
    }
}

