/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.quark;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.quark.api.IRuneColorProvider;

public class QuarkCompat {
    private static Capability<IRuneColorProvider> runeColorCap = null;

    @CapabilityInject(value=IRuneColorProvider.class)
    public static void runesAvailable(Capability<IRuneColorProvider> runeColorCap) {
        QuarkCompat.runeColorCap = runeColorCap;
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, QuarkCompat::itemCapInit);
    }

    private static void itemCapInit(AttachCapabilitiesEvent<ItemStack> evt) {
        evt.addCapability(ResourceLocationHelper.prefix("headflower_glint"), (ICapabilityProvider)new Provider((ItemStack)evt.getObject()));
    }

    private static class Provider
    implements ICapabilityProvider {
        private static final LazyOptional<IRuneColorProvider> COLOR = LazyOptional.of(() -> s -> DyeColor.YELLOW.func_196059_a());
        private final ItemStack stack;

        public Provider(ItemStack stack) {
            this.stack = stack;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            CompoundNBT tag = this.stack.func_77978_p();
            if (tag != null && tag.func_74767_n("botania:headflower")) {
                return runeColorCap.orEmpty(cap, COLOR);
            }
            return LazyOptional.empty();
        }
    }
}

