/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.item.IFlowerPlaceable;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.mixin.AccessorItemEntity;

public class SubTileRannuncarpus
extends TileEntityFunctionalFlower {
    private static final int PICKUP_RANGE = 2;
    private static final int PICKUP_RANGE_Y = 3;
    private static final int RANGE_PLACE_MANA = 8;
    private static final int RANGE_PLACE = 6;
    private static final int RANGE_PLACE_Y = 6;
    private static final int RANGE_PLACE_MANA_MINI = 3;
    private static final int RANGE_PLACE_MINI = 2;
    private static final int RANGE_PLACE_Y_MINI = 2;
    private static final String TAG_STATE_SENSITIVE = "stateSensitive";
    private boolean stateSensitive = false;

    public SubTileRannuncarpus(TileEntityType<?> type) {
        super(type);
    }

    public SubTileRannuncarpus() {
        this(ModSubtiles.RANNUNCARPUS);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_72995_K || this.redstoneSignal > 0) {
            return;
        }
        if (this.ticksExisted % 10 == 0) {
            List items = this.func_145831_w().func_217357_a(ItemEntity.class, new AxisAlignedBB(this.getEffectivePos().func_177982_a(-2, -3, -2), this.getEffectivePos().func_177982_a(3, 4, 3)));
            int slowdown = this.getSlowdownFactor();
            for (ItemEntity item : items) {
                BlockPos coords;
                ItemStack stack;
                Item stackItem;
                ResourceLocation id;
                int age = ((AccessorItemEntity)item).getAge();
                if (age < 60 + slowdown || !item.func_70089_S() || item.func_92059_d().func_190926_b() || ConfigHandler.blacklistedRannuncarpusModIds.contains((id = Registry.field_212630_s.func_177774_c((Object)(stackItem = (stack = item.func_92059_d()).func_77973_b()))).func_110624_b()) || ConfigHandler.blacklistedRannuncarpusItems.contains(id) || !(stackItem instanceof BlockItem) && !(stackItem instanceof IFlowerPlaceable) || (coords = this.getCandidatePosition(this.func_145831_w().field_73012_v)) == null) continue;
                BlockRayTraceResult ray = new BlockRayTraceResult(new Vector3d((double)coords.func_177958_n() + 0.5, (double)(coords.func_177956_o() + 1), (double)coords.func_177952_p() + 0.5), Direction.UP, coords, false);
                RannuncarpusPlaceContext ctx = new RannuncarpusPlaceContext(this.func_145831_w(), stack, ray, this.field_174879_c);
                boolean success = false;
                if (stackItem instanceof IFlowerPlaceable) {
                    success = ((IFlowerPlaceable)stackItem).tryPlace(this, ctx);
                }
                if (stackItem instanceof BlockItem) {
                    success = ((BlockItem)stackItem).func_195942_a((BlockItemUseContext)ctx).func_226246_a_();
                }
                if (!success) continue;
                if (((Boolean)ConfigHandler.COMMON.blockBreakParticles.get()).booleanValue()) {
                    BlockState state = this.func_145831_w().func_180495_p(ctx.func_195995_a());
                    this.func_145831_w().func_217379_c(2001, coords, Block.func_196246_j((BlockState)state));
                }
                if (this.getMana() > 1) {
                    this.addMana(-1);
                }
                return;
            }
        }
    }

    public BlockState getUnderlyingBlock() {
        return this.func_145831_w().func_180495_p(this.getEffectivePos().func_177979_c(this.isFloating() ? 1 : 2));
    }

    @Nullable
    private BlockPos getCandidatePosition(Random rand) {
        int rangePlace = this.getPlaceRange();
        int rangePlaceY = this.getVerticalPlaceRange();
        BlockPos center = this.getEffectivePos();
        BlockState filter = this.getUnderlyingBlock();
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)center.func_177982_a(-rangePlace, -rangePlaceY, -rangePlace), (BlockPos)center.func_177982_a(rangePlace, rangePlaceY, rangePlace))) {
            BlockState state = this.func_145831_w().func_180495_p(pos);
            BlockState up = this.func_145831_w().func_180495_p(pos.func_177984_a());
            boolean matches = this.stateSensitive ? state == filter : state.func_203425_a(filter.func_177230_c());
            if (!matches || !up.isAir((IBlockReader)this.func_145831_w(), pos.func_177984_a()) && !up.func_185904_a().func_76222_j()) continue;
            ret.add(pos.func_185334_h());
        }
        return ret.isEmpty() ? null : (BlockPos)ret.get(rand.nextInt(ret.size()));
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        this.stateSensitive = cmp.func_74764_b(TAG_STATE_SENSITIVE) ? cmp.func_74767_n(TAG_STATE_SENSITIVE) : true;
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74757_a(TAG_STATE_SENSITIVE, this.stateSensitive);
    }

    @Override
    public boolean onWanded(PlayerEntity player, ItemStack wand) {
        if (player == null || player.func_225608_bj_()) {
            this.stateSensitive = !this.stateSensitive;
            this.func_70296_d();
            this.sync();
            return true;
        }
        return super.onWanded(player, wand);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(MatrixStack ms, Minecraft mc) {
        super.renderHUD(ms, mc);
        BlockState filter = this.getUnderlyingBlock();
        ItemStack recieverStack = new ItemStack((IItemProvider)filter.func_177230_c());
        int color = this.getColor();
        if (!recieverStack.func_190926_b()) {
            ITextComponent stackName = recieverStack.func_200301_q();
            int width = 16 + mc.field_71466_p.func_238414_a_((ITextProperties)stackName) / 2;
            int x = mc.func_228018_at_().func_198107_o() / 2 - width;
            int y = mc.func_228018_at_().func_198087_p() / 2 + 30;
            mc.field_71466_p.func_243246_a(ms, stackName, (float)(x + 20), (float)(y + 5), color);
            mc.func_175599_af().func_180450_b(recieverStack, x, y);
            String mode = I18n.func_135052_a((String)("botaniamisc.rannuncarpus." + (this.stateSensitive ? "state_sensitive" : "state_insensitive")), (Object[])new Object[0]);
            x = mc.func_228018_at_().func_198107_o() / 2 - mc.field_71466_p.func_78256_a(mode) / 2;
            y = mc.func_228018_at_().func_198087_p() / 2 + 50;
            mc.field_71466_p.func_238405_a_(ms, mode, (float)x, (float)y, TextFormatting.WHITE.func_211163_e().intValue());
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), this.getPlaceRange());
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        if (this.getPlaceRange() == 2) {
            return null;
        }
        return new RadiusDescriptor.Square(this.getEffectivePos(), 2);
    }

    public int getPlaceRange() {
        return this.getMana() > 0 ? 8 : 6;
    }

    public int getVerticalPlaceRange() {
        return 6;
    }

    @Override
    public int getMaxMana() {
        return 20;
    }

    @Override
    public int getColor() {
        return 16757375;
    }

    private static class RannuncarpusPlaceContext
    extends BlockItemUseContext {
        private final Direction[] lookDirs;
        private final float placementYaw;

        public RannuncarpusPlaceContext(World world, ItemStack stack, BlockRayTraceResult rtr, BlockPos flowerPos) {
            super(world, null, Hand.MAIN_HAND, stack, rtr);
            int dx = rtr.func_216350_a().func_177958_n() - flowerPos.func_177958_n();
            int dy = rtr.func_216350_a().func_177956_o() - flowerPos.func_177956_o();
            int dz = rtr.func_216350_a().func_177952_p() - flowerPos.func_177952_p();
            Direction xClosest = dx >= 0 ? Direction.EAST : Direction.WEST;
            Direction yClosest = dy >= 0 ? Direction.UP : Direction.DOWN;
            Direction zClosest = dz >= 0 ? Direction.SOUTH : Direction.NORTH;
            List<Direction> directions = RannuncarpusPlaceContext.sortThree(xClosest, yClosest, zClosest, Math.abs(dx), Math.abs(dy), Math.abs(dz));
            Direction first = directions.get(0);
            Direction second = directions.get(1);
            Direction third = directions.get(2);
            this.lookDirs = new Direction[]{first, second, third, third.func_176734_d(), second.func_176734_d(), first.func_176734_d()};
            this.placementYaw = (float)(-MathHelper.func_181159_b((double)dx, (double)dz) * 180.0 / Math.PI);
        }

        private static <T> List<T> sortThree(T a, T b, T c, int aInt, int bInt, int cInt) {
            if (aInt >= bInt) {
                if (bInt >= cInt) {
                    return ImmutableList.of(a, b, c);
                }
                return cInt >= aInt ? ImmutableList.of(c, a, b) : ImmutableList.of(a, c, b);
            }
            if (bInt >= cInt) {
                return cInt >= aInt ? ImmutableList.of(b, c, a) : ImmutableList.of(b, a, c);
            }
            return ImmutableList.of(c, b, a);
        }

        @Nonnull
        public Direction func_196010_d() {
            return this.func_196009_e()[0];
        }

        @Nonnull
        public Direction[] func_196009_e() {
            return this.lookDirs;
        }

        @Nonnull
        public Direction func_195992_f() {
            return this.func_196010_d().func_176740_k().func_176722_c() ? this.func_196010_d() : this.func_196009_e()[1];
        }

        public float func_195990_h() {
            return this.placementYaw;
        }
    }

    public static class Mini
    extends SubTileRannuncarpus {
        public Mini() {
            super(ModSubtiles.RANNUNCARPUS_CHIBI);
        }

        @Override
        public int getPlaceRange() {
            return this.getMana() > 0 ? 3 : 2;
        }

        @Override
        public int getVerticalPlaceRange() {
            return 2;
        }
    }
}

