/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.lib.ModTags;

public class SubTileRafflowsia
extends TileEntityGeneratingFlower {
    public static final String TAG_LAST_FLOWERS = "lastFlowers";
    public static final String TAG_LAST_FLOWER_TIMES = "lastFlowerTimes";
    public static final String TAG_STREAK_LENGTH = "streakLength";
    private List<Block> lastFlowers = new LinkedList<Block>();
    private int streakLength = -1;
    private int lastFlowerCount = 0;
    private static final int RANGE = 5;
    private static final int[] STREAK_OUTPUTS = new int[]{300, 1100, 1900, 2700, 3500, 4400, 5300, 6300, 7300, 8300, 9400, 10500, 11600, 12800, 14000, 15200, 16500, 17900, 19200, 20700, 22200, 23800, 25400, 27100, 29000, 30900, 33000, 35200, 37700, 40300, 43200, 46500, 50200, 54300, 59100, 64600, 71100, 78600, 87600, 98400};

    public SubTileRafflowsia() {
        super(ModSubtiles.RAFFLOWSIA);
    }

    private int getMaxStreak() {
        return STREAK_OUTPUTS.length - 1;
    }

    private int getValueForStreak(int index) {
        if (index != 0) {
            this.lastFlowerCount = 0;
        }
        return STREAK_OUTPUTS[index] / ++this.lastFlowerCount;
    }

    private int processFlower(Block flower) {
        ListIterator<Block> it = this.lastFlowers.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            Block streakFlower = it.next();
            if (streakFlower != flower) continue;
            it.remove();
            this.lastFlowers.add(0, streakFlower);
            return index;
        }
        this.lastFlowers.add(0, flower);
        if (this.lastFlowers.size() >= this.getMaxStreak()) {
            this.lastFlowers.remove(this.lastFlowers.size() - 1);
        }
        return this.getMaxStreak();
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        int mana = 2100;
        if (this.getMaxMana() - this.getMana() >= mana && !this.func_145831_w().field_72995_K && this.ticksExisted % 40 == 0) {
            for (int i = 0; i < 11; ++i) {
                for (int j = 0; j < 11; ++j) {
                    for (int k = 0; k < 11; ++k) {
                        BlockPos pos = this.getEffectivePos().func_177982_a(i - 5, j - 5, k - 5);
                        BlockState state = this.func_145831_w().func_180495_p(pos);
                        if (!state.func_235714_a_(ModTags.Blocks.SPECIAL_FLOWERS) || state.func_177230_c() == ModSubtiles.rafflowsia) continue;
                        this.streakLength = Math.min(this.streakLength + 1, this.processFlower(state.func_177230_c()));
                        this.func_145831_w().func_175655_b(pos, false);
                        this.addMana(this.getValueForStreak(this.streakLength));
                        this.sync();
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        ListNBT flowerList = new ListNBT();
        for (Block flower : this.lastFlowers) {
            flowerList.add((Object)StringNBT.func_229705_a_((String)Registry.field_212618_g.func_177774_c((Object)flower).toString()));
        }
        cmp.func_218657_a(TAG_LAST_FLOWERS, (INBT)flowerList);
        cmp.func_74768_a(TAG_LAST_FLOWER_TIMES, this.lastFlowerCount);
        cmp.func_74768_a(TAG_STREAK_LENGTH, this.streakLength);
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        this.lastFlowers.clear();
        ListNBT flowerList = cmp.func_150295_c(TAG_LAST_FLOWERS, 8);
        for (int i = 0; i < flowerList.size(); ++i) {
            this.lastFlowers.add((Block)Registry.field_212618_g.func_82594_a(ResourceLocation.func_208304_a((String)flowerList.func_150307_f(i))));
        }
        this.lastFlowerCount = cmp.func_74762_e(TAG_LAST_FLOWER_TIMES);
        this.streakLength = cmp.func_74762_e(TAG_STREAK_LENGTH);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 5);
    }

    @Override
    public int getColor() {
        return 5254262;
    }

    @Override
    public int getMaxMana() {
        return 100000;
    }
}

