/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileExposedSimpleInventory;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.brew.ItemIncenseStick;

public class TileIncensePlate
extends TileExposedSimpleInventory
implements ISidedInventory,
ITickableTileEntity {
    private static final String TAG_TIME_LEFT = "timeLeft";
    private static final String TAG_BURNING = "burning";
    private static final int RANGE = 32;
    private int timeLeft = 0;
    public boolean burning = false;
    public int comparatorOutput = 0;

    public TileIncensePlate() {
        super(ModTiles.INCENSE_PLATE);
    }

    public void func_73660_a() {
        ItemStack stack = this.getItemHandler().func_70301_a(0);
        if (!stack.func_190926_b() && this.burning) {
            if (((Boolean)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && this.timeLeft > 1) {
                this.timeLeft = 1;
                this.spawnSmokeParticles();
            }
            Brew brew = ((ItemIncenseStick)ModItems.incenseStick).getBrew(stack);
            EffectInstance effect = brew.getPotionEffects(stack).get(0);
            if (this.timeLeft > 0) {
                --this.timeLeft;
                if (!this.field_145850_b.field_72995_K) {
                    List players = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.5 - 32.0, (double)this.field_174879_c.func_177956_o() + 0.5 - 32.0, (double)this.field_174879_c.func_177952_p() + 0.5 - 32.0, (double)this.field_174879_c.func_177958_n() + 0.5 + 32.0, (double)this.field_174879_c.func_177956_o() + 0.5 + 32.0, (double)this.field_174879_c.func_177952_p() + 0.5 + 32.0));
                    for (PlayerEntity player : players) {
                        boolean nightVision;
                        EffectInstance currentEffect = player.func_70660_b(effect.func_188419_a());
                        boolean bl = nightVision = effect.func_188419_a() == Effects.field_76439_r;
                        if (currentEffect != null && currentEffect.func_76459_b() >= (nightVision ? 205 : 3)) continue;
                        EffectInstance applyEffect = new EffectInstance(effect.func_188419_a(), nightVision ? 285 : 80, effect.func_76458_c(), true, true);
                        player.func_195064_c(applyEffect);
                    }
                    if (this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.1f, 1.0f);
                    }
                } else {
                    double x = (double)this.field_174879_c.func_177958_n() + 0.5;
                    double y = (double)this.field_174879_c.func_177956_o() + 0.5;
                    double z = (double)this.field_174879_c.func_177952_p() + 0.5;
                    int color = brew.getColor(stack);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    WispParticleData data1 = WispParticleData.wisp(0.05f + (float)Math.random() * 0.02f, r, g, b);
                    this.field_145850_b.func_195594_a((IParticleData)data1, x - (Math.random() - 0.5) * 0.2, y - (Math.random() - 0.5) * 0.2, z - (Math.random() - 0.5) * 0.2, (double)(0.005f - (float)Math.random() * 0.01f), (double)(0.01f + (float)Math.random() * 0.005f), (double)(0.005f - (float)Math.random() * 0.01f));
                    WispParticleData data = WispParticleData.wisp(0.05f + (float)Math.random() * 0.02f, 0.2f, 0.2f, 0.2f);
                    this.field_145850_b.func_195594_a((IParticleData)data, x - (Math.random() - 0.5) * 0.2, y - (Math.random() - 0.5) * 0.2, z - (Math.random() - 0.5) * 0.2, (double)(0.005f - (float)Math.random() * 0.01f), (double)(0.01f + (float)Math.random() * 0.001f), (double)(0.005f - (float)Math.random() * 0.01f));
                }
            } else {
                this.getItemHandler().func_70299_a(0, ItemStack.field_190927_a);
                this.burning = false;
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
        } else {
            this.timeLeft = 0;
        }
        int newComparator = 0;
        if (!stack.func_190926_b()) {
            newComparator = 1;
        }
        if (this.burning) {
            newComparator = 2;
        }
        if (this.comparatorOutput != newComparator) {
            this.comparatorOutput = newComparator;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    public void spawnSmokeParticles() {
        Random random = this.field_145850_b.func_201674_k();
        for (int i = 0; i < 4; ++i) {
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + 0.5 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.05, 0.0);
        }
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.1f, 1.0f);
    }

    public void ignite() {
        ItemStack stack = this.getItemHandler().func_70301_a(0);
        if (stack.func_190926_b() || this.burning) {
            return;
        }
        if (((Boolean)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            this.spawnSmokeParticles();
            return;
        }
        this.burning = true;
        Brew brew = ((ItemIncenseStick)ModItems.incenseStick).getBrew(stack);
        this.timeLeft = brew.getPotionEffects(stack).get(0).func_76459_b() * 60;
    }

    @Override
    public void writePacketNBT(CompoundNBT tag) {
        super.writePacketNBT(tag);
        tag.func_74768_a(TAG_TIME_LEFT, this.timeLeft);
        tag.func_74757_a(TAG_BURNING, this.burning);
    }

    @Override
    public void readPacketNBT(CompoundNBT tag) {
        super.readPacketNBT(tag);
        this.timeLeft = tag.func_74762_e(TAG_TIME_LEFT);
        this.burning = tag.func_74767_n(TAG_BURNING);
    }

    public boolean acceptsItem(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == ModItems.incenseStick && ((ItemIncenseStick)ModItems.incenseStick).getBrew(stack) != ModBrews.fallbackBrew;
    }

    @Override
    protected Inventory createItemHandler() {
        return new Inventory(1){

            public boolean func_94041_b(int index, ItemStack stack) {
                return TileIncensePlate.this.acceptsItem(stack);
            }
        };
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
        return false;
    }
}

