/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;

public class TileCorporeaRetainer
extends TileMod {
    private static final String TAG_REQUEST_X = "requestX";
    private static final String TAG_REQUEST_Y = "requestY";
    private static final String TAG_REQUEST_Z = "requestZ";
    private static final String TAG_REQUEST_TYPE = "requestType";
    private static final String TAG_REQUEST_COUNT = "requestCount";
    private static final String TAG_RETAIN_MISSING = "retainMissing";
    private static final Map<ResourceLocation, Function<CompoundNBT, ? extends ICorporeaRequestMatcher>> corporeaMatcherDeserializers = new ConcurrentHashMap<ResourceLocation, Function<CompoundNBT, ? extends ICorporeaRequestMatcher>>();
    private static final Map<Class<? extends ICorporeaRequestMatcher>, ResourceLocation> corporeaMatcherSerializers = new ConcurrentHashMap<Class<? extends ICorporeaRequestMatcher>, ResourceLocation>();
    private BlockPos requestPos = BlockPos.field_177992_a;
    @Nullable
    private ICorporeaRequestMatcher request;
    private int requestCount;
    private int compValue;
    private boolean retainMissing = false;

    public TileCorporeaRetainer() {
        super(ModTiles.CORPOREA_RETAINER);
    }

    public void remember(BlockPos pos, ICorporeaRequestMatcher request, int count, int missing) {
        if (this.hasPendingRequest()) {
            return;
        }
        this.requestPos = pos;
        this.request = request;
        this.requestCount = this.retainMissing ? missing : count;
        this.compValue = CorporeaHelper.instance().signalStrengthForRequestSize(this.requestCount);
        this.func_70296_d();
    }

    public int getComparatorValue() {
        return this.compValue;
    }

    public boolean hasPendingRequest() {
        return this.request != null;
    }

    public void fulfilRequest() {
        TileEntity te;
        if (!this.hasPendingRequest()) {
            return;
        }
        ICorporeaSpark spark = CorporeaHelper.instance().getSparkForBlock(this.field_145850_b, this.requestPos);
        if (spark != null && (te = spark.getSparkNode().getWorld().func_175625_s(spark.getSparkNode().getPos())) instanceof ICorporeaRequestor) {
            ICorporeaRequestor requestor = (ICorporeaRequestor)te;
            requestor.doCorporeaRequest(this.request, this.requestCount, spark);
            this.request = null;
            this.requestCount = 0;
            this.compValue = 0;
            this.func_70296_d();
        }
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        ResourceLocation reqType;
        super.writePacketNBT(cmp);
        cmp.func_74768_a(TAG_REQUEST_X, this.requestPos.func_177958_n());
        cmp.func_74768_a(TAG_REQUEST_Y, this.requestPos.func_177956_o());
        cmp.func_74768_a(TAG_REQUEST_Z, this.requestPos.func_177952_p());
        ResourceLocation resourceLocation = reqType = this.request != null ? corporeaMatcherSerializers.get(this.request.getClass()) : null;
        if (reqType != null) {
            cmp.func_74778_a(TAG_REQUEST_TYPE, reqType.toString());
            this.request.writeToNBT(cmp);
            cmp.func_74768_a(TAG_REQUEST_COUNT, this.requestCount);
        }
        cmp.func_74757_a(TAG_RETAIN_MISSING, this.retainMissing);
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        super.readPacketNBT(cmp);
        int x = cmp.func_74762_e(TAG_REQUEST_X);
        int y = cmp.func_74762_e(TAG_REQUEST_Y);
        int z = cmp.func_74762_e(TAG_REQUEST_Z);
        this.requestPos = new BlockPos(x, y, z);
        ResourceLocation reqType = ResourceLocation.func_208304_a((String)cmp.func_74779_i(TAG_REQUEST_TYPE));
        this.request = reqType != null && corporeaMatcherDeserializers.containsKey(reqType) ? corporeaMatcherDeserializers.get(reqType).apply(cmp) : null;
        this.requestCount = cmp.func_74762_e(TAG_REQUEST_COUNT);
        this.retainMissing = cmp.func_74767_n(TAG_RETAIN_MISSING);
    }

    public static <T extends ICorporeaRequestMatcher> void addCorporeaRequestMatcher(ResourceLocation id, Class<T> clazz, Function<CompoundNBT, T> deserializer) {
        corporeaMatcherSerializers.put(clazz, id);
        corporeaMatcherDeserializers.put(id, deserializer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(MatrixStack ms, Minecraft mc) {
        String mode = I18n.func_135052_a((String)("botaniamisc.retainer." + (this.retainMissing ? "retain_missing" : "retain_all")), (Object[])new Object[0]);
        int x = mc.func_228018_at_().func_198107_o() / 2 - mc.field_71466_p.func_78256_a(mode) / 2;
        int y = mc.func_228018_at_().func_198087_p() / 2 + 10;
        mc.field_71466_p.func_238405_a_(ms, mode, (float)x, (float)y, TextFormatting.GRAY.func_211163_e().intValue());
    }

    public boolean onUsedByWand() {
        if (!this.field_145850_b.field_72995_K) {
            this.retainMissing = !this.retainMissing;
            this.func_70296_d();
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }
}

