/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class RecipeManaInfusion
implements IManaInfusionRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final Ingredient input;
    private final int mana;
    @Nullable
    private final StateIngredient catalyst;
    private final String group;

    public RecipeManaInfusion(ResourceLocation id, ItemStack output, Ingredient input, int mana, @Nullable String group, @Nullable StateIngredient catalyst) {
        Preconditions.checkArgument((mana > 0 ? 1 : 0) != 0, (Object)"Mana cost must be positive");
        Preconditions.checkArgument((mana <= 1000001 ? 1 : 0) != 0, (Object)"Mana cost must be at most a pool");
        this.id = id;
        this.output = output;
        this.input = input;
        this.mana = mana;
        this.group = group == null ? "" : group;
        this.catalyst = catalyst;
    }

    @Deprecated
    public RecipeManaInfusion(ResourceLocation id, ItemStack output, Ingredient input, int mana, @Nullable String group, @Nullable BlockState catalystState) {
        this(id, output, input, mana, group, StateIngredientHelper.of(catalystState));
    }

    @Nonnull
    public final ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<RecipeManaInfusion> func_199559_b() {
        return ModRecipeTypes.MANA_INFUSION_SERIALIZER;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    @Override
    @Nullable
    public BlockState getCatalyst() {
        if (this.catalyst == null) {
            return null;
        }
        return this.catalyst.getDisplayed().get(0);
    }

    @Override
    public StateIngredient getRecipeCatalyst() {
        return this.catalyst;
    }

    @Override
    public int getManaToConsume() {
        return this.mana;
    }

    @Override
    @Nonnull
    public ItemStack func_77571_b() {
        return this.output;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.input});
    }

    @Nonnull
    public String func_193358_e() {
        return this.group;
    }

    @Nonnull
    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModBlocks.manaPool);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeManaInfusion> {
        @Nonnull
        public RecipeManaInfusion read(@Nonnull ResourceLocation id, @Nonnull JsonObject json) {
            JsonElement input = Objects.requireNonNull(json.get("input"));
            Ingredient ing = Ingredient.func_199802_a((JsonElement)input);
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
            int mana = JSONUtils.func_151203_m((JsonObject)json, (String)"mana");
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            StateIngredient catalyst = null;
            if (json.has("catalyst")) {
                JsonElement element = json.get("catalyst");
                if (element.isJsonPrimitive()) {
                    String s = JSONUtils.func_151200_h((JsonObject)json, (String)"catalyst");
                    ResourceLocation catalystId = ResourceLocation.func_208304_a((String)s);
                    if (catalystId == null) {
                        throw new IllegalArgumentException("Invalid catalyst ID: " + s);
                    }
                    catalyst = StateIngredientHelper.of((Block)Registry.field_212618_g.func_241873_b(catalystId).orElseThrow(() -> new IllegalArgumentException("Unknown catalyst: " + s)));
                } else {
                    catalyst = !element.getAsJsonObject().has("type") ? StateIngredientHelper.of(StateIngredientHelper.readBlockState(JSONUtils.func_152754_s((JsonObject)json, (String)"catalyst"))) : StateIngredientHelper.deserialize(element.getAsJsonObject());
                }
            }
            return new RecipeManaInfusion(id, output, ing, mana, group, catalyst);
        }

        @Nullable
        public RecipeManaInfusion read(@Nonnull ResourceLocation id, @Nonnull PacketBuffer buf) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buf);
            ItemStack output = buf.func_150791_c();
            int mana = buf.func_150792_a();
            StateIngredient catalyst = null;
            if (buf.readBoolean()) {
                catalyst = StateIngredientHelper.read(buf);
            }
            String group = buf.func_218666_n();
            return new RecipeManaInfusion(id, output, input, mana, group, catalyst);
        }

        public void write(@Nonnull PacketBuffer buf, @Nonnull RecipeManaInfusion recipe) {
            ((Ingredient)recipe.func_192400_c().get(0)).func_199564_a(buf);
            buf.writeItemStack(recipe.func_77571_b(), false);
            buf.func_150787_b(recipe.getManaToConsume());
            boolean hasCatalyst = recipe.getRecipeCatalyst() != null;
            buf.writeBoolean(hasCatalyst);
            if (hasCatalyst) {
                recipe.getRecipeCatalyst().write(buf);
            }
            buf.func_180714_a(recipe.func_193358_e());
        }
    }
}

