/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import vazkii.botania.client.gui.bag.ContainerFlowerBag;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.item.ItemBackedInventory;

public class ItemFlowerBag
extends Item {
    public static final int SIZE = 16;

    public ItemFlowerBag(Item.Properties props) {
        super(props);
        MinecraftForge.EVENT_BUS.addListener(this::onPickupItem);
    }

    public static boolean isValid(int slot, ItemStack stack) {
        Block blk = Block.func_149634_a((Item)stack.func_77973_b());
        return !stack.func_190926_b() && blk.getClass() == BlockModFlower.class && slot == ((BlockModFlower)blk).color.func_196059_a();
    }

    public static Inventory getInventory(ItemStack stack) {
        return new ItemBackedInventory(stack, 16){

            public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
                return ItemFlowerBag.isValid(slot, stack);
            }
        };
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT oldCapNbt) {
        return new InvProvider(stack);
    }

    private void onPickupItem(EntityItemPickupEvent event) {
        ItemStack entityStack = event.getItem().func_92059_d();
        if (Block.func_149634_a((Item)entityStack.func_77973_b()) instanceof BlockModFlower && entityStack.func_190916_E() > 0) {
            int color = ((BlockModFlower)Block.func_149634_a((Item)entityStack.func_77973_b())).color.func_196059_a();
            for (int i = 0; i < event.getPlayer().field_71071_by.func_70302_i_(); ++i) {
                Inventory bagInv;
                ItemStack existing;
                int newCount;
                int numPickedUp;
                ItemStack bag;
                if (i == event.getPlayer().field_71071_by.field_70461_c || (bag = event.getPlayer().field_71071_by.func_70301_a(i)).func_190926_b() || bag.func_77973_b() != this || (numPickedUp = (newCount = Math.min((existing = (bagInv = ItemFlowerBag.getInventory(bag)).func_70301_a(color)).func_190916_E() + entityStack.func_190916_E(), Math.min(existing.func_77976_d(), bagInv.func_70297_j_()))) - existing.func_190916_E()) <= 0) continue;
                if (existing.func_190926_b()) {
                    bagInv.func_70299_a(color, entityStack.func_77979_a(numPickedUp));
                } else {
                    existing.func_190917_f(numPickedUp);
                    entityStack.func_190918_g(numPickedUp);
                }
                event.getItem().func_92058_a(entityStack);
                bagInv.func_70296_d();
                event.setCanceled(true);
                event.getPlayer().func_71001_a((Entity)event.getItem(), numPickedUp);
                return;
            }
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            SimpleNamedContainerProvider container = new SimpleNamedContainerProvider((w, p, pl) -> new ContainerFlowerBag(w, p, stack), stack.func_200301_q());
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)container, buf -> buf.writeBoolean(hand == Hand.MAIN_HAND));
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        Direction side = ctx.func_196000_l();
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            if (!world.field_72995_K) {
                IItemHandler tileInv;
                if (tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).isPresent()) {
                    tileInv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).orElseThrow(NullPointerException::new);
                } else if (tile instanceof IInventory) {
                    tileInv = new InvWrapper((IInventory)tile);
                } else {
                    return ActionResultType.FAIL;
                }
                Inventory bagInv = ItemFlowerBag.getInventory(ctx.func_195996_i());
                for (int i = 0; i < bagInv.func_70302_i_(); ++i) {
                    ItemStack flower = bagInv.func_70301_a(i);
                    ItemStack rem = ItemHandlerHelper.insertItemStacked((IItemHandler)tileInv, (ItemStack)flower, (boolean)false);
                    bagInv.func_70299_a(i, rem);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private static class InvProvider
    implements ICapabilityProvider {
        private final LazyOptional<IItemHandler> opt = LazyOptional.of(() -> new InvWrapper((IInventory)ItemFlowerBag.getInventory(stack)));

        private InvProvider(ItemStack stack) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.opt);
        }
    }
}

