/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;

public class PacketUpdateItemsRemaining {
    private final ItemStack stack;
    private final int count;
    @Nullable
    private final ITextComponent tooltip;

    public PacketUpdateItemsRemaining(ItemStack stack, int count, @Nullable ITextComponent tooltip) {
        this.stack = stack;
        this.count = count;
        this.tooltip = tooltip;
    }

    public static PacketUpdateItemsRemaining decode(PacketBuffer buf) {
        return new PacketUpdateItemsRemaining(buf.func_150791_c(), buf.func_150792_a(), buf.func_179258_d());
    }

    public void encode(PacketBuffer buf) {
        buf.func_150788_a(this.stack);
        buf.func_150787_b(this.count);
        buf.func_179256_a(this.tooltip);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            ctx.get().enqueueWork(() -> ItemsRemainingRenderHandler.set(this.stack, this.count, this.tooltip));
            ctx.get().setPacketHandled(true);
        }
    }
}

