/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.mixin;

import java.util.Iterator;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateRecipesPacket;
import net.minecraft.server.management.PlayerList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import vazkii.botania.common.network.PacketHandler;
import vazkii.botania.common.network.PacketOrechidData;

@Mixin(value={PlayerList.class})
public class MixinPlayerList {
    @Inject(method={"initializeConnectionToPlayer"}, at={@At(value="NEW", target="net/minecraft/network/play/server/SUpdateRecipesPacket")})
    private void sendOrechidData(NetworkManager netManager, ServerPlayerEntity playerIn, CallbackInfo ci) {
        PacketHandler.sendNonLocal(playerIn, PacketOrechidData.create());
    }

    @Inject(method={"reloadResources"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/item/crafting/ServerRecipeBook;init(Lnet/minecraft/entity/player/ServerPlayerEntity;)V", shift=At.Shift.AFTER)})
    private void resendOrechidData(CallbackInfo ci, SUpdateRecipesPacket packet, Iterator<ServerPlayerEntity> iter, ServerPlayerEntity player) {
        PacketHandler.sendNonLocal(player, PacketOrechidData.create());
    }
}

