/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.mixin;

import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundEngine;
import net.minecraft.util.SoundCategory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.botania.common.block.subtile.functional.SubTileBergamute;

@Mixin(value={SoundEngine.class})
public class MixinSoundEngine {
    @Unique
    private ISound tmpSound;

    @Inject(at={@At(value="HEAD")}, method={"getClampedVolume"})
    private void captureSound(ISound sound, CallbackInfoReturnable<Float> cir) {
        this.tmpSound = sound;
    }

    @Unique
    private static boolean shouldSilence(ISound sound) {
        return sound != null && sound.func_184365_d() != SoundCategory.VOICE && sound.func_184365_d() != SoundCategory.MUSIC && sound.func_184365_d() != SoundCategory.RECORDS && sound.func_184365_d() != SoundCategory.AMBIENT;
    }

    @ModifyArg(index=0, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;clamp(FFF)F"), method={"getClampedVolume"})
    private float bergamuateAttenuate(float volume) {
        int count;
        if (MixinSoundEngine.shouldSilence(this.tmpSound) && (count = SubTileBergamute.countFlowersAround(this.tmpSound)) > 0) {
            return volume * (float)Math.pow(0.5, count);
        }
        return volume;
    }

    @Inject(at={@At(value="RETURN")}, method={"getClampedVolume"})
    private void clearSound(ISound sound, CallbackInfoReturnable<Float> cir) {
        this.tmpSound = null;
    }
}

