/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block.tile;

import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.config.ConfigManager;

@Mod.EventBusSubscriber(modid="lootr")
public class TileTicker {
    private static final Object listLock = new Object();
    private static final Object worldLock = new Object();
    private static boolean tickingList = false;
    private static final Set<Entry> tileEntries = new ObjectLinkedOpenHashSet();
    private static final Set<Entry> pendingEntries = new ObjectLinkedOpenHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntry(World level, BlockPos position) {
        if (level.func_201670_d()) {
            return;
        }
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            return;
        }
        RegistryKey dimension = level.func_234923_W_();
        if (ConfigManager.isDimensionBlocked((RegistryKey<World>)dimension)) {
            return;
        }
        WorldBorder border = level.func_175723_af();
        if (!border.func_177746_a(position)) {
            return;
        }
        Entry newEntry = new Entry((RegistryKey<World>)dimension, position, new ChunkPos(position), ServerLifecycleHooks.getCurrentServer().func_71259_af());
        Object object = listLock;
        synchronized (object) {
            if (tickingList) {
                pendingEntries.add(newEntry);
            } else {
                tileEntries.add(newEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        ObjectLinkedOpenHashSet copy;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ObjectLinkedOpenHashSet toRemove = new ObjectLinkedOpenHashSet();
        Object object = listLock;
        synchronized (object) {
            tickingList = true;
            copy = new ObjectLinkedOpenHashSet(tileEntries);
            tickingList = false;
        }
        object = worldLock;
        synchronized (object) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            for (Entry entry : copy) {
                ServerWorld level = server.func_71218_a(entry.getDimension());
                if (level == null || !level.func_175723_af().func_177730_a(entry.getChunkPosition()) || entry.age(server) > (long)((Integer)ConfigManager.MAXIMUM_AGE.get()).intValue()) {
                    toRemove.add(entry);
                    continue;
                }
                ServerChunkProvider provider = level.func_72863_F();
                ChunkPos pos = entry.getChunkPosition();
                Chunk chunk = (Chunk)provider.func_212849_a_(pos.field_77276_a, pos.field_77275_b, ChunkStatus.field_222617_m, false);
                if (chunk == null) continue;
                TileEntity tile = level.func_175625_s(entry.getPosition());
                if (!(tile instanceof LockableLootTileEntity) || tile instanceof ILootTile) {
                    toRemove.add(entry);
                    continue;
                }
                LockableLootTileEntity te = (LockableLootTileEntity)tile;
                if (te.field_184284_m == null || ConfigManager.isBlacklisted(te.field_184284_m)) {
                    toRemove.add(entry);
                    continue;
                }
                ResourceLocation table = te.field_184284_m;
                long seed = te.field_184285_n;
                BlockState stateAt = level.func_180495_p(entry.getPosition());
                BlockState replacement = ConfigManager.replacement(stateAt);
                if (replacement == null) {
                    toRemove.add(entry);
                    continue;
                }
                chunk.field_201618_i.remove(entry.getPosition());
                level.func_175713_t(entry.getPosition());
                level.func_180501_a(entry.getPosition(), replacement, 2);
                tile = level.func_175625_s(entry.getPosition());
                if (tile instanceof ILootTile) {
                    ((LockableLootTileEntity)tile).func_189404_a(table, seed);
                } else {
                    Lootr.LOG.error("replacement " + replacement + " is not an ILootTile " + entry.getDimension() + " at " + entry.getPosition());
                }
                toRemove.add(entry);
            }
        }
        object = listLock;
        synchronized (object) {
            tickingList = true;
            tileEntries.removeAll((Collection<?>)toRemove);
            tileEntries.addAll(pendingEntries);
            tickingList = false;
            pendingEntries.clear();
        }
    }

    public static class Entry {
        private final RegistryKey<World> dimension;
        private final BlockPos position;
        private final ChunkPos chunkPos;
        private final long addedAt;

        public Entry(RegistryKey<World> dimension, BlockPos position, ChunkPos chunkPos, long addedAt) {
            this.dimension = dimension;
            this.position = position;
            this.chunkPos = chunkPos;
            this.addedAt = addedAt;
        }

        public RegistryKey<World> getDimension() {
            return this.dimension;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public ChunkPos getChunkPosition() {
            return this.chunkPos;
        }

        public long age(MinecraftServer server) {
            return (long)server.func_71259_af() - this.addedAt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.dimension.equals(entry.dimension)) {
                return false;
            }
            return this.position.equals((Object)entry.position);
        }

        public int hashCode() {
            int result = this.dimension.hashCode();
            result = 31 * result + this.position.hashCode();
            return result;
        }
    }
}

