/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.init.ModBlocks;

@Mod.EventBusSubscriber(modid="lootr", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigManager {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    private static final List<ResourceLocation> QUARK_CHESTS = Arrays.asList(new ResourceLocation("quark", "oak_chest"), new ResourceLocation("quark", "spruce_chest"), new ResourceLocation("quark", "birch_chest"), new ResourceLocation("quark", "jungle_chest"), new ResourceLocation("quark", "acacia_chest"), new ResourceLocation("quark", "dark_oak_chest"), new ResourceLocation("quark", "warped_chest"), new ResourceLocation("quark", "crimson_chest"), new ResourceLocation("quark", "nether_brick_chest"), new ResourceLocation("quark", "purpur_chest"));
    private static final List<ResourceLocation> QUARK_TRAPPED_CHESTS = Arrays.asList(new ResourceLocation("quark", "oak_trapped_chest"), new ResourceLocation("quark", "spruce_trapped_chest"), new ResourceLocation("quark", "birch_trapped_chest"), new ResourceLocation("quark", "jungle_trapped_chest"), new ResourceLocation("quark", "acacia_trapped_chest"), new ResourceLocation("quark", "dark_oak_trapped_chest"), new ResourceLocation("quark", "warped_trapped_chest"), new ResourceLocation("quark", "crimson_trapped_chest"));
    private static final List<ResourceLocation> PROBLEMATIC_CHESTS = Arrays.asList(new ResourceLocation("atum", "chests/pharaoh"), new ResourceLocation("twilightforest", "structures/stronghold_boss"));
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static final ForgeConfigSpec.BooleanValue REPORT_UNRESOLVED_TABLES;
    public static final ForgeConfigSpec.BooleanValue RANDOMISE_SEED;
    public static final ForgeConfigSpec.BooleanValue CONVERT_MINESHAFTS;
    public static final ForgeConfigSpec.BooleanValue CONVERT_QUARK;
    public static final ForgeConfigSpec.BooleanValue CONVERT_WOODEN_CHESTS;
    public static final ForgeConfigSpec.BooleanValue CONVERT_TRAPPED_CHESTS;
    public static final ForgeConfigSpec.BooleanValue DISABLE_BREAK;
    public static final ForgeConfigSpec.BooleanValue ENABLE_FAKE_PLAYER_BREAK;
    public static final ForgeConfigSpec.IntValue DECAY_VALUE;
    public static final ForgeConfigSpec.IntValue REFRESH_VALUE;
    public static final ForgeConfigSpec.BooleanValue DECAY_ALL;
    public static final ForgeConfigSpec.BooleanValue REFRESH_ALL;
    public static final ForgeConfigSpec.IntValue NOTIFICATION_DELAY;
    public static final ForgeConfigSpec.BooleanValue DISABLE_NOTIFICATIONS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ADDITIONAL_CHESTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ADDITIONAL_TRAPPED_CHESTS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DIMENSION_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DIMENSION_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LOOT_TABLE_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> LOOT_MODID_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DECAY_MODIDS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DECAY_LOOT_TABLES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DECAY_DIMENSIONS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> REFRESH_MODIDS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> REFRESH_LOOT_TABLES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> REFRESH_DIMENSIONS;
    public static final ForgeConfigSpec.BooleanValue VANILLA_TEXTURES;
    public static final ForgeConfigSpec.BooleanValue POWER_COMPARATORS;
    public static final ForgeConfigSpec.BooleanValue BLAST_RESISTANT;
    public static final ForgeConfigSpec.BooleanValue BLAST_IMMUNE;
    public static final ForgeConfigSpec.IntValue MAXIMUM_AGE;
    public static final ForgeConfigSpec.BooleanValue BYPASS_SPAWN_PROTECTION;
    private static Set<String> DECAY_MODS;
    private static Set<ResourceLocation> DECAY_TABLES;
    private static Set<String> REFRESH_MODS;
    private static Set<ResourceLocation> REFRESH_TABLES;
    private static Set<RegistryKey<World>> DIM_WHITELIST;
    private static Set<RegistryKey<World>> DIM_BLACKLIST;
    private static Set<RegistryKey<World>> DECAY_DIMS;
    private static Set<RegistryKey<World>> REFRESH_DIMS;
    private static Set<ResourceLocation> LOOT_BLACKLIST;
    private static Set<ResourceLocation> ADD_CHESTS;
    private static Set<ResourceLocation> ADD_TRAPPED_CHESTS;
    private static Map<Block, Block> replacements;
    private static Set<String> LOOT_MOD_BLACKLIST;

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    @SubscribeEvent
    public static void reloadConfig(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            COMMON_CONFIG.setConfig(event.getConfig().getConfigData());
            replacements = null;
            DIM_WHITELIST = null;
            DIM_BLACKLIST = null;
            LOOT_BLACKLIST = null;
            ADD_CHESTS = null;
            ADD_TRAPPED_CHESTS = null;
            DECAY_MODS = null;
            DECAY_TABLES = null;
            DECAY_DIMS = null;
            LOOT_MOD_BLACKLIST = null;
            REFRESH_MODS = null;
            REFRESH_TABLES = null;
            REFRESH_DIMS = null;
        }
    }

    public static Set<RegistryKey<World>> getDimensionWhitelist() {
        if (DIM_WHITELIST == null) {
            DIM_WHITELIST = ((List)DIMENSION_WHITELIST.get()).stream().map(o -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(o))).collect(Collectors.toSet());
        }
        return DIM_WHITELIST;
    }

    public static Set<RegistryKey<World>> getDimensionBlacklist() {
        if (DIM_BLACKLIST == null) {
            DIM_BLACKLIST = ((List)DIMENSION_BLACKLIST.get()).stream().map(o -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(o))).collect(Collectors.toSet());
        }
        return DIM_BLACKLIST;
    }

    public static Set<RegistryKey<World>> getDecayDimensions() {
        if (DECAY_DIMS == null) {
            DECAY_DIMS = ((List)DECAY_DIMENSIONS.get()).stream().map(o -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(o))).collect(Collectors.toSet());
        }
        return DECAY_DIMS;
    }

    public static Set<RegistryKey<World>> getRefreshDimensions() {
        if (REFRESH_DIMS == null) {
            REFRESH_DIMS = ((List)REFRESH_DIMENSIONS.get()).stream().map(o -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(o))).collect(Collectors.toSet());
        }
        return REFRESH_DIMS;
    }

    public static boolean isBlacklisted(ResourceLocation table) {
        if (ConfigManager.getLootBlacklist().contains(table)) {
            return true;
        }
        return ConfigManager.getModBlacklist().contains(table.func_110624_b());
    }

    public static Set<ResourceLocation> getLootBlacklist() {
        if (LOOT_BLACKLIST == null) {
            LOOT_BLACKLIST = ((List)LOOT_TABLE_BLACKLIST.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
            LOOT_BLACKLIST.addAll(PROBLEMATIC_CHESTS);
        }
        return LOOT_BLACKLIST;
    }

    public static Set<String> getModBlacklist() {
        if (LOOT_MOD_BLACKLIST == null) {
            LOOT_MOD_BLACKLIST = ((List)LOOT_MODID_BLACKLIST.get()).stream().map(String::toLowerCase).collect(Collectors.toSet());
        }
        return LOOT_MOD_BLACKLIST;
    }

    public static Set<ResourceLocation> getDecayingTables() {
        if (DECAY_TABLES == null) {
            DECAY_TABLES = ((List)DECAY_LOOT_TABLES.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
        }
        return DECAY_TABLES;
    }

    public static Set<ResourceLocation> getRefreshingTables() {
        if (REFRESH_TABLES == null) {
            REFRESH_TABLES = ((List)REFRESH_LOOT_TABLES.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
        }
        return REFRESH_TABLES;
    }

    public static Set<String> getDecayMods() {
        if (DECAY_MODS == null) {
            DECAY_MODS = ((List)DECAY_MODIDS.get()).stream().map(o -> o.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        }
        return DECAY_MODS;
    }

    public static Set<String> getRefreshMods() {
        if (REFRESH_MODS == null) {
            REFRESH_MODS = ((List)REFRESH_MODIDS.get()).stream().map(o -> o.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        }
        return REFRESH_MODS;
    }

    public static Set<ResourceLocation> getAdditionalChests() {
        if (ADD_CHESTS == null) {
            ADD_CHESTS = ((List)ADDITIONAL_CHESTS.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
        }
        return ADD_CHESTS;
    }

    public static Set<ResourceLocation> getAdditionalTrappedChests() {
        if (ADD_TRAPPED_CHESTS == null) {
            ADD_TRAPPED_CHESTS = ((List)ADDITIONAL_TRAPPED_CHESTS.get()).stream().map(ResourceLocation::new).collect(Collectors.toSet());
        }
        return ADD_TRAPPED_CHESTS;
    }

    public static boolean isDimensionBlocked(RegistryKey<World> key) {
        return !ConfigManager.getDimensionWhitelist().isEmpty() && !ConfigManager.getDimensionWhitelist().contains(key) || ConfigManager.getDimensionBlacklist().contains(key);
    }

    public static boolean isDimensionDecaying(RegistryKey<World> key) {
        return ConfigManager.getDecayDimensions().contains(key);
    }

    public static boolean isDimensionRefreshing(RegistryKey<World> key) {
        return ConfigManager.getRefreshDimensions().contains(key);
    }

    public static boolean isDecaying(World world, ILootTile tile) {
        if (tile.getTable() == null) {
            return false;
        }
        if (((Boolean)DECAY_ALL.get()).booleanValue()) {
            return true;
        }
        if (ConfigManager.getDecayingTables().contains(tile.getTable())) {
            return true;
        }
        if (ConfigManager.getDecayMods().contains(tile.getTable().func_110624_b().toLowerCase(Locale.ROOT))) {
            return true;
        }
        return ConfigManager.isDimensionDecaying((RegistryKey<World>)world.func_234923_W_());
    }

    public static boolean isRefreshing(World world, ILootTile tile) {
        if (tile.getTable() == null) {
            return false;
        }
        if (((Boolean)REFRESH_ALL.get()).booleanValue()) {
            return true;
        }
        if (tile.getTable() != null) {
            if (ConfigManager.getRefreshingTables().contains(tile.getTable())) {
                return true;
            }
            if (ConfigManager.getRefreshMods().contains(tile.getTable().func_110624_b().toLowerCase(Locale.ROOT))) {
                return true;
            }
        }
        return ConfigManager.isDimensionRefreshing((RegistryKey<World>)world.func_234923_W_());
    }

    public static boolean isDecaying(World world, LootrChestMinecartEntity entity) {
        if (entity.field_184290_c == null) {
            return false;
        }
        if (((Boolean)DECAY_ALL.get()).booleanValue()) {
            return true;
        }
        if (ConfigManager.getDecayingTables().contains(entity.field_184290_c)) {
            return true;
        }
        if (ConfigManager.getDecayMods().contains(entity.field_184290_c.func_110624_b().toLowerCase(Locale.ROOT))) {
            return true;
        }
        return ConfigManager.isDimensionDecaying((RegistryKey<World>)world.func_234923_W_());
    }

    public static boolean isRefreshing(World world, LootrChestMinecartEntity entity) {
        if (entity.field_184290_c == null) {
            return false;
        }
        if (((Boolean)REFRESH_ALL.get()).booleanValue()) {
            return true;
        }
        if (ConfigManager.getRefreshingTables().contains(entity.field_184290_c)) {
            return true;
        }
        if (ConfigManager.getRefreshMods().contains(entity.field_184290_c.func_110624_b().toLowerCase(Locale.ROOT))) {
            return true;
        }
        return ConfigManager.isDimensionRefreshing((RegistryKey<World>)world.func_234923_W_());
    }

    private static void addSafeReplacement(ResourceLocation location, Block replacement) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
        if (block != null) {
            replacements.put(block, replacement);
        }
    }

    private static void addUnsafeReplacement(ResourceLocation location, Block replacement, ServerWorld world) {
        TileEntity tile;
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
        if (block != null && (tile = block.createTileEntity(block.func_176223_P(), (IBlockReader)world)) instanceof LockableLootTileEntity) {
            replacements.put(block, replacement);
        }
    }

    public static BlockState replacement(BlockState original) {
        Block replacement;
        if (replacements == null) {
            ServerWorld world;
            replacements = new HashMap<Block, Block>();
            replacements.put(Blocks.field_150486_ae, (Block)ModBlocks.CHEST);
            replacements.put(Blocks.field_222422_lK, (Block)ModBlocks.BARREL);
            replacements.put(Blocks.field_150447_bR, (Block)ModBlocks.TRAPPED_CHEST);
            replacements.put(Blocks.field_204409_il, (Block)ModBlocks.SHULKER);
            if (((Boolean)CONVERT_QUARK.get()).booleanValue() && ModList.get().isLoaded("quark")) {
                QUARK_TRAPPED_CHESTS.forEach(o -> ConfigManager.addSafeReplacement(o, (Block)ModBlocks.TRAPPED_CHEST));
                QUARK_CHESTS.forEach(o -> ConfigManager.addSafeReplacement(o, (Block)ModBlocks.CHEST));
            }
            if (((Boolean)CONVERT_WOODEN_CHESTS.get()).booleanValue() || ((Boolean)CONVERT_TRAPPED_CHESTS.get()).booleanValue()) {
                world = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_);
                if (((Boolean)CONVERT_TRAPPED_CHESTS.get()).booleanValue()) {
                    Tags.Blocks.CHESTS_TRAPPED.func_230236_b_().forEach(o -> {
                        if (replacements.containsKey(o)) {
                            return;
                        }
                        TileEntity tile = o.createTileEntity(o.func_176223_P(), (IBlockReader)world);
                        if (tile instanceof LockableLootTileEntity) {
                            replacements.put((Block)o, (Block)ModBlocks.TRAPPED_CHEST);
                        }
                    });
                }
                if (((Boolean)CONVERT_WOODEN_CHESTS.get()).booleanValue()) {
                    Tags.Blocks.CHESTS_WOODEN.func_230236_b_().forEach(o -> {
                        if (replacements.containsKey(o)) {
                            return;
                        }
                        TileEntity tile = o.createTileEntity(o.func_176223_P(), (IBlockReader)world);
                        if (tile instanceof LockableLootTileEntity) {
                            replacements.put((Block)o, (Block)ModBlocks.CHEST);
                        }
                    });
                }
                if (((Boolean)CONVERT_WOODEN_CHESTS.get()).booleanValue()) {
                    HashSet enderChests = new HashSet(Tags.Blocks.CHESTS_ENDER.func_230236_b_());
                    Tags.Blocks.CHESTS.func_230236_b_().forEach(o -> {
                        if (replacements.containsKey(o) || enderChests.contains(o)) {
                            return;
                        }
                        TileEntity tile = o.createTileEntity(o.func_176223_P(), (IBlockReader)world);
                        if (tile instanceof LockableLootTileEntity) {
                            replacements.put((Block)o, (Block)ModBlocks.CHEST);
                        }
                    });
                }
            }
            if (!ConfigManager.getAdditionalChests().isEmpty() || !ConfigManager.getAdditionalTrappedChests().isEmpty()) {
                world = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_);
                ConfigManager.getAdditionalChests().forEach(o -> ConfigManager.addUnsafeReplacement(o, (Block)ModBlocks.CHEST, world));
                ConfigManager.getAdditionalTrappedChests().forEach(o -> ConfigManager.addUnsafeReplacement(o, (Block)ModBlocks.TRAPPED_CHEST, world));
            }
        }
        if ((replacement = replacements.get(original.func_177230_c())) == null) {
            return null;
        }
        return ConfigManager.copyProperties(replacement.func_176223_P(), original);
    }

    private static BlockState copyProperties(BlockState state, BlockState original) {
        for (Property prop : original.func_235904_r_()) {
            if (!state.func_235901_b_(prop)) continue;
            state = ConfigManager.safeReplace(state, original, prop);
        }
        return state;
    }

    private static <V extends Comparable<V>> BlockState safeReplace(BlockState state, BlockState original, Property<V> property) {
        if (property == ChestBlock.field_196314_b && state.func_235901_b_(property)) {
            return (BlockState)state.func_206870_a((Property)ChestBlock.field_196314_b, (Comparable)ChestType.SINGLE);
        }
        if (original.func_235901_b_(property) && state.func_235901_b_(property)) {
            return (BlockState)state.func_206870_a(property, original.func_177229_b(property));
        }
        return state;
    }

    public static boolean isVanillaTextures() {
        return (Boolean)VANILLA_TEXTURES.get();
    }

    public static boolean shouldNotify(int remaining) {
        int delay = (Integer)NOTIFICATION_DELAY.get();
        return (Boolean)DISABLE_NOTIFICATIONS.get() == false && (delay == -1 || remaining <= delay);
    }

    static {
        DECAY_MODS = null;
        DECAY_TABLES = null;
        REFRESH_MODS = null;
        REFRESH_TABLES = null;
        DIM_WHITELIST = null;
        DIM_BLACKLIST = null;
        DECAY_DIMS = null;
        REFRESH_DIMS = null;
        LOOT_BLACKLIST = null;
        ADD_CHESTS = null;
        ADD_TRAPPED_CHESTS = null;
        replacements = null;
        LOOT_MOD_BLACKLIST = null;
        RANDOMISE_SEED = COMMON_BUILDER.comment("determine whether or not loot generated is the same for all players using the provided seed, or randomised per player").define("randomise_seed", true);
        MAXIMUM_AGE = COMMON_BUILDER.comment("the maximum age for containers; entries above this age will be discarded [default: 180 * 20, 3 minutes]").defineInRange("maximum_age", 3600, 0, Integer.MAX_VALUE);
        CONVERT_MINESHAFTS = COMMON_BUILDER.comment("whether or not mineshaft chest minecarts should be converted to standard loot chests").define("convert_mineshafts", true);
        CONVERT_QUARK = COMMON_BUILDER.comment("whether or not quark chests used in world generation for loot purposes should be replaced with Lootr chests").define("convert_quark", true);
        CONVERT_WOODEN_CHESTS = COMMON_BUILDER.comment("whether or not the entire forge:chests/wooden tag should be added to the conversion list for structures (if they are backed by LockableLootTileEntity)").define("convert_wooden_chests", true);
        CONVERT_TRAPPED_CHESTS = COMMON_BUILDER.comment("whether or not the entire forge:chests/trapped tag should be added to the conversion list for structures (if they are backed by LockableLootTileEntity").define("convert_trapped_chests", true);
        List empty = Collections.emptyList();
        Predicate<Object> validator = o -> o instanceof String && ((String)o).contains(":");
        REPORT_UNRESOLVED_TABLES = COMMON_BUILDER.comment("lootr will automatically log all unresolved tables (i.e., for containers that have a loot table associated with them but, for whatever reason, the lookup for this table returns empty). setting this option to true additionally informs players when they open containers.").define("report_unresolved_tables", false);
        ADDITIONAL_CHESTS = COMMON_BUILDER.comment("a list of additional chests that should be converted [in the format of modid:name, must be a tile entity instance of LockableLootTileEntity]").defineList("additional_chests", empty, validator);
        ADDITIONAL_TRAPPED_CHESTS = COMMON_BUILDER.comment("a list of additional trapped chests that should be converted [in the format of modid:name, must be a tile entity instanceof LockableLootTileEntity]").defineList("additional_trapped_chests", empty, validator);
        DIMENSION_WHITELIST = COMMON_BUILDER.comment("list of dimensions (to the exclusion of all others) that loot chest should be replaced in [default: blank, allowing all dimensions, e.g., minecraft:overworld]").defineList("dimension_whitelist", empty, validator);
        DIMENSION_BLACKLIST = COMMON_BUILDER.comment("list of dimensions that loot chests should not be replaced in [default: blank, allowing all dimensions, format e.g., minecraft:overworld]").defineList("dimension_blacklist", empty, validator);
        LOOT_TABLE_BLACKLIST = COMMON_BUILDER.comment("list of loot tables which shouldn't be converted [in the format of modid:loot_table]").defineList("loot_table_blacklist", empty, validator);
        LOOT_MODID_BLACKLIST = COMMON_BUILDER.comment("list of modids which shouldn't be converted [in the format of modid, modid]").defineList("loot_mod_blacklist", empty, o -> o instanceof String);
        DISABLE_BREAK = COMMON_BUILDER.comment("prevent the destruction of Lootr chests except while sneaking in creative mode").define("disable_break", false);
        ENABLE_FAKE_PLAYER_BREAK = COMMON_BUILDER.comment("allows fake players to destroy Lootr chests without having to sneak, overrides the `disable_break` option for fake players").define("enable_fake_player_break", false);
        POWER_COMPARATORS = COMMON_BUILDER.comment("when true, comparators on Lootr containers will give an output of 1; when false, they will give an output of 0").define("power_comparators", true);
        BLAST_RESISTANT = COMMON_BUILDER.comment("lootr chests cannot be destroyed by creeper or TNT explosions").define("blast_resistant", false);
        BLAST_IMMUNE = COMMON_BUILDER.comment("lootr chests cannot be destroyed by any explosion").define("blast_immune", false);
        BYPASS_SPAWN_PROTECTION = COMMON_BUILDER.comment("lootr chests can be modified (opened, etc.) even within spawn protected areas").define("bypass_spawn_protection", true);
        DECAY_VALUE = COMMON_BUILDER.comment("how long (in ticks) a decaying loot containers should take to decay [default 5 minutes = 5 * 60 * 20]").defineInRange("decay_value", 6000, 0, Integer.MAX_VALUE);
        DECAY_LOOT_TABLES = COMMON_BUILDER.comment("list of loot tables which will decay [default blank, meaning no chests decay, in the format of 'modid:loot_table']").defineList("decay_loot_tables", empty, validator);
        DECAY_MODIDS = COMMON_BUILDER.comment("list of mod IDs whose loot tables will decay [default blank, meaning no chests decay, in the format of 'modid', 'modid']").defineList("decay_modids", empty, o -> o instanceof String);
        DECAY_DIMENSIONS = COMMON_BUILDER.comment("list of dimensions where loot chests should automatically decay [default: blank, e.g., minecraft:overworld]").defineList("decay_dimensions", empty, validator);
        DECAY_ALL = COMMON_BUILDER.comment("overriding decay_loot_tables, decay_modids and decay_dimensions: all chests will decay after being opened for the first time").define("decay_all", false);
        REFRESH_VALUE = COMMON_BUILDER.comment("how long (in ticks) before the contents of a loot container will be refresh [default 20 minutes = 20 * 60 * 20]").defineInRange("refresh_value", 24000, 0, Integer.MAX_VALUE);
        REFRESH_LOOT_TABLES = COMMON_BUILDER.comment("list of loot tables which will refresh [default blank, meaning no chests refresh, in the format of 'modid:loot_table']").defineList("refresh_loot_tables", empty, validator);
        REFRESH_MODIDS = COMMON_BUILDER.comment("list of mod IDs whose loot tables will refresh [default blank, meaning no chests refresh, in the format of 'modid', 'modid']").defineList("refresh_modids", empty, o -> o instanceof String);
        REFRESH_DIMENSIONS = COMMON_BUILDER.comment("list of dimensions where loot chests should automatically refresh [default: blank, e.g., minecraft:overworld]").defineList("refresh_dimensions", empty, validator);
        REFRESH_ALL = COMMON_BUILDER.comment("overriding refresh_loot_tables, refresh_modids and refresh_dimensions: all chests will refresh after being opened for the first time").define("refresh_all", false);
        DISABLE_NOTIFICATIONS = COMMON_BUILDER.comment("prevent notifications of decaying or refreshed chests").define("disable_notifications", false);
        NOTIFICATION_DELAY = COMMON_BUILDER.comment("maximum time (in ticks) remaining on a chest before a notification for refreshing or decaying is sent to a player (default 30 seconds, -1 for no delay)").defineInRange("notification_delay", 600, -1, Integer.MAX_VALUE);
        COMMON_CONFIG = COMMON_BUILDER.build();
        VANILLA_TEXTURES = CLIENT_BUILDER.comment("set to true to use vanilla textures instead of Lootr special textures. Note: this will prevent previously opened chests from rendering differently").define("vanilla_textures", false);
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

