/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.repack.shoulders.info;

import com.google.gson.JsonObject;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import noobanidus.mods.lootr.repack.shoulders.info.Shoulder;
import noobanidus.mods.lootr.repack.shoulders.info.ShoulderEntity;

public class ShoulderData
implements INBTSerializable<CompoundNBT> {
    private UUID player;
    private ShoulderEntity entity;
    private Shoulder shoulder;
    private int variant;

    public ShoulderData(UUID player, ShoulderEntity entity, Shoulder shoulder, int variant) {
        this.player = player;
        this.entity = entity;
        this.shoulder = shoulder;
        this.variant = variant;
    }

    private ShoulderData() {
    }

    public UUID getPlayer() {
        return this.player;
    }

    public ShoulderEntity getEntity() {
        return this.entity;
    }

    public boolean left() {
        return this.getShoulder().left();
    }

    public boolean right() {
        return this.getShoulder().right();
    }

    public boolean head() {
        return this.getShoulder().head();
    }

    public Shoulder getShoulder() {
        return this.shoulder;
    }

    public int getVariant() {
        return this.variant;
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        result.addProperty("player", this.player.toString());
        result.addProperty("entity", this.entity.getName());
        result.addProperty("shoulder", this.shoulder.getName());
        result.addProperty("variant", (Number)this.variant);
        return result;
    }

    public static ShoulderData fromJson(JsonObject source) {
        ShoulderEntity entity = ShoulderEntity.getByName(source.get("entity").getAsString());
        Shoulder shoulder = Shoulder.getByName(source.get("shoulder").getAsString());
        int variant = source.get("variant").getAsInt();
        UUID player = UUID.fromString(source.get("player").getAsString());
        return new ShoulderData(player, entity, shoulder, variant);
    }

    public static ShoulderData fromNBT(CompoundNBT tag) {
        ShoulderData data = new ShoulderData();
        data.deserializeNBT(tag);
        return data;
    }

    public CompoundNBT serializeNBT() {
        return null;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.player = nbt.func_186857_a("player");
        this.shoulder = Shoulder.getByName(nbt.func_74779_i("shoulder"));
        this.entity = ShoulderEntity.getByName(nbt.func_74779_i("entity"));
        this.variant = nbt.func_74762_e("variant");
    }
}

