/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.client.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;

public class ElevatorBakedModel
extends BakedModelWrapper<IBakedModel> {
    public static final ModelProperty<BlockState> HELD_STATE = new ModelProperty();

    public ElevatorBakedModel(IBakedModel originalModel) {
        super(originalModel);
    }

    @Nonnull
    public List<BakedQuad> getQuads(BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState heldState;
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>();
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        if (layer == RenderType.func_228641_d_() && side == null && ((Boolean)state.func_177229_b((Property)ElevatorBlock.DIRECTIONAL)).booleanValue() && ((Boolean)state.func_177229_b((Property)ElevatorBlock.SHOW_ARROW)).booleanValue()) {
            IBakedModel arrowModel = dispatcher.func_175023_a().func_178126_b().getModel(new ResourceLocation("elevatorid", "arrow"));
            ModelRotation rot = ModelRotation.func_177524_a((int)0, (int)((int)((Direction)state.func_177229_b((Property)ElevatorBlock.field_185512_D)).func_185119_l()));
            QuadTransformer transformer = new QuadTransformer(rot.func_225615_b_().blockCenterToCorner());
            result.addAll(transformer.processMany(arrowModel.getQuads(state, null, rand, extraData)));
        }
        if ((heldState = (BlockState)extraData.getData(HELD_STATE)) != null) {
            if (RenderTypeLookup.canRenderInLayer((BlockState)heldState, (RenderType)layer)) {
                IBakedModel model = dispatcher.func_184389_a(heldState);
                result.addAll(model.getQuads(heldState, side, rand, extraData));
            }
            return result;
        }
        if (layer == RenderType.func_228639_c_() || layer == null) {
            result.addAll(this.originalModel.getQuads(state, side, rand, extraData));
        }
        return result;
    }

    @Nonnull
    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        BlockState state = (BlockState)data.getData(HELD_STATE);
        if (state != null) {
            return Minecraft.func_71410_x().func_175602_ab().func_184389_a(state).getParticleTexture(data);
        }
        return super.getParticleTexture(data);
    }
}

