/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.loot.BinomialRange;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.loot.TagLootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.EnchantWithLevels;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public abstract class LootTableGenerator
extends ResourceGenerator {
    private static final Gson GSON = LootSerializers.func_237388_c_().create();
    private final Map<ResourceLocation, LootTableBuilder> lootTables = new HashMap<ResourceLocation, LootTableBuilder>();

    public LootTableGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (LootTableBuilder lootTableBuilder : this.lootTables.values()) {
            JsonObject json = new JsonObject();
            if (lootTableBuilder.parameters != LootParameterSets.field_216266_g) {
                json.addProperty("type", LootParameterSets.func_216257_a((LootParameterSet)lootTableBuilder.parameters).toString());
            }
            if (!lootTableBuilder.functions.isEmpty()) {
                JsonArray functionsJson = new JsonArray();
                for (ILootFunction function : lootTableBuilder.functions) {
                    functionsJson.add(GSON.toJsonTree((Object)function));
                }
                json.add("functions", (JsonElement)functionsJson);
            }
            if (!lootTableBuilder.pools.isEmpty()) {
                JsonArray poolsJson = new JsonArray();
                for (LootPoolBuilder pool : lootTableBuilder.pools) {
                    JsonObject poolJson = new JsonObject();
                    if (pool.name != null && !pool.name.isEmpty()) {
                        poolJson.addProperty("name", pool.name);
                    }
                    poolJson.add("rolls", GSON.toJsonTree((Object)pool.rolls));
                    if (!(pool.bonusRolls instanceof ConstantRange) || pool.bonusRolls.func_186511_a(null) != 0) {
                        poolJson.add("bonus_rolls", GSON.toJsonTree((Object)pool.bonusRolls));
                    }
                    if (!pool.conditions.isEmpty()) {
                        JsonArray conditionsJson = new JsonArray();
                        for (ILootCondition condition : pool.conditions) {
                            conditionsJson.add(GSON.toJsonTree((Object)condition));
                        }
                        poolJson.add("conditions", (JsonElement)conditionsJson);
                    }
                    if (!pool.functions.isEmpty()) {
                        JsonArray functionsJson = new JsonArray();
                        for (ILootFunction function : pool.functions) {
                            functionsJson.add(GSON.toJsonTree((Object)function));
                        }
                        poolJson.add("functions", (JsonElement)functionsJson);
                    }
                    if (pool.entries.isEmpty()) {
                        throw new RuntimeException("Loot table '" + lootTableBuilder.identifier + "' has loot pool without any entries!");
                    }
                    JsonArray entriesJson = new JsonArray();
                    for (LootEntry entry : pool.entries) {
                        entriesJson.add(GSON.toJsonTree((Object)entry));
                    }
                    poolJson.add("entries", (JsonElement)entriesJson);
                    poolsJson.add((JsonElement)poolJson);
                }
                json.add("pools", (JsonElement)poolsJson);
            }
            ResourceLocation identifier = lootTableBuilder.identifier;
            this.cache.saveJsonResource(ResourceType.DATA, json, identifier.func_110624_b(), "loot_tables", identifier.func_110623_a());
        }
    }

    protected LootTableBuilder lootTable(ResourceLocation identifier) {
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, identifier.func_110624_b(), "loot_tables", identifier.func_110623_a(), ".json");
        return this.lootTables.computeIfAbsent(identifier, LootTableBuilder::new);
    }

    protected LootTableBuilder lootTable(String namespace, String path) {
        return this.lootTable(new ResourceLocation(namespace, path));
    }

    protected LootTableBuilder lootTable(Block block) {
        return this.lootTable(block.func_220068_i());
    }

    protected LootTableBuilder dropSelf(Block block) {
        return this.lootTable(block).blockParameters().pool(poolBuilder -> poolBuilder.survivesExplosionCondition().itemEntry((IItemProvider)block));
    }

    protected LootTableBuilder dropSelfWhenSilkTouch(Block block) {
        return this.lootTable(block).blockParameters().pool(poolBuilder -> poolBuilder.hasEnchantmentCondition(Enchantments.field_185306_r).itemEntry((IItemProvider)block));
    }

    @Override
    public String getName() {
        return this.modName + " Loot Table Generator";
    }

    public static class LootPoolBuilder {
        private final List<ILootCondition> conditions = new ArrayList<ILootCondition>();
        private final List<ILootFunction> functions = new ArrayList<ILootFunction>();
        private final List<LootEntry> entries = new ArrayList<LootEntry>();
        private IRandomRange rolls = ConstantRange.func_215835_a((int)1);
        private IRandomRange bonusRolls = ConstantRange.func_215835_a((int)0);
        private String name;

        protected LootPoolBuilder() {
        }

        public LootPoolBuilder rolls(IRandomRange provider) {
            this.rolls = provider;
            return this;
        }

        public LootPoolBuilder constantRolls(int rolls) {
            return this.rolls((IRandomRange)ConstantRange.func_215835_a((int)rolls));
        }

        public LootPoolBuilder uniformRolls(int min, int max) {
            return this.rolls((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max));
        }

        public LootPoolBuilder binomialRolls(int n, int p) {
            return this.rolls((IRandomRange)BinomialRange.func_215838_a((int)n, (float)p));
        }

        public LootPoolBuilder bonusRolls(IRandomRange provider) {
            this.bonusRolls = provider;
            return this;
        }

        public LootPoolBuilder constantBonusRolls(int rolls) {
            return this.bonusRolls((IRandomRange)ConstantRange.func_215835_a((int)rolls));
        }

        public LootPoolBuilder uniformBonusRolls(int min, int max) {
            return this.bonusRolls((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max));
        }

        public LootPoolBuilder binomialBonusRolls(int n, int p) {
            return this.bonusRolls((IRandomRange)BinomialRange.func_215838_a((int)n, (float)p));
        }

        public LootPoolBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LootPoolBuilder condition(ILootCondition condition) {
            if (Registry.field_239704_ba_.func_177774_c((Object)condition.func_230419_b_()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered loot pool condition '" + condition + "'!");
            }
            this.conditions.add(condition);
            return this;
        }

        public LootPoolBuilder survivesExplosionCondition() {
            return this.condition(SurvivesExplosion.func_215968_b().build());
        }

        public LootPoolBuilder hasEnchantmentCondition(Enchantment enchantment, int minLevel, int maxLevel) {
            return this.condition(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(enchantment, new MinMaxBounds.IntBound(Integer.valueOf(minLevel), Integer.valueOf(maxLevel))))).build());
        }

        public LootPoolBuilder hasEnchantmentCondition(Enchantment enchantment, int minLevel) {
            return this.condition(MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(enchantment, MinMaxBounds.IntBound.func_211340_b((int)minLevel)))).build());
        }

        public LootPoolBuilder hasEnchantmentCondition(Enchantment enchantment) {
            return this.hasEnchantmentCondition(enchantment, 1);
        }

        public LootPoolBuilder entry(LootEntry entry) {
            if (Registry.field_239693_aY_.func_177774_c((Object)entry.func_230420_a_()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered loot pool entry '" + entry + "'!");
            }
            this.entries.add(entry);
            return this;
        }

        private LootPoolBuilder entry(StandaloneLootEntry.Builder<?> entry, int weight) {
            if (weight <= 0) {
                throw new IllegalArgumentException("Loot entry weight must be greater than zero, not '" + weight + "'!");
            }
            return this.entry(entry.func_216086_a(weight).func_216081_b());
        }

        public LootPoolBuilder emptyEntry(int weight) {
            return this.entry(EmptyLootEntry.func_216167_a(), weight);
        }

        public LootPoolBuilder emptyEntry() {
            return this.emptyEntry(1);
        }

        public LootPoolBuilder itemEntry(IItemProvider item, int weight) {
            return this.entry(ItemLootEntry.func_216168_a((IItemProvider)item), weight);
        }

        public LootPoolBuilder itemEntry(IItemProvider item) {
            return this.itemEntry(item, 1);
        }

        public LootPoolBuilder itemEntry(IItemProvider item, int count, int weight) {
            return this.entry(ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)count))), weight);
        }

        public LootPoolBuilder itemEntry(IItemProvider item, int min, int max, int weight) {
            return this.entry(ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max))), weight);
        }

        public LootPoolBuilder itemEntry(ResourceLocation item) {
            if (!Registries.ITEMS.hasIdentifier(item)) {
                throw new IllegalArgumentException("Could not find any item registered under '" + item + "'!");
            }
            return this.itemEntry((IItemProvider)Registries.ITEMS.getValue(item));
        }

        public LootPoolBuilder itemEntry(String namespace, String identifier) {
            return this.itemEntry(new ResourceLocation(namespace, identifier));
        }

        public LootPoolBuilder enchantedItemEntry(IItemProvider item, int levels, boolean allowCurses, int weight) {
            EnchantWithLevels.Builder builder = EnchantWithLevels.func_215895_a((IRandomRange)ConstantRange.func_215835_a((int)levels));
            if (allowCurses) {
                builder.func_216059_e();
            }
            return this.entry(ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)builder), weight);
        }

        public LootPoolBuilder enchantedItemEntry(IItemProvider item, int minLevels, int maxLevels, boolean allowCurses, int weight) {
            EnchantWithLevels.Builder builder = EnchantWithLevels.func_215895_a((IRandomRange)RandomValueRange.func_215837_a((float)minLevels, (float)maxLevels));
            if (allowCurses) {
                builder.func_216059_e();
            }
            return this.entry(ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)builder), weight);
        }

        public LootPoolBuilder tagEntry(ITag<Item> tagKey, int weight) {
            return this.entry(TagLootEntry.func_216176_b(tagKey), weight);
        }

        public LootPoolBuilder tagEntry(ITag<Item> tag) {
            return this.entry(TagLootEntry.func_216176_b(tag).func_216081_b());
        }

        public LootPoolBuilder tagEntry(ResourceLocation tag, int weight) {
            return this.tagEntry((ITag<Item>)ItemTags.createOptional((ResourceLocation)tag), weight);
        }

        public LootPoolBuilder tagEntry(ResourceLocation tag) {
            return this.tagEntry((ITag<Item>)ItemTags.createOptional((ResourceLocation)tag));
        }

        public LootPoolBuilder tagEntry(String namespace, String path, int weight) {
            return this.tagEntry(new ResourceLocation(namespace, path), weight);
        }

        public LootPoolBuilder tagEntry(String namespace, String path) {
            return this.tagEntry(new ResourceLocation(namespace, path));
        }

        public LootPoolBuilder lootTableEntry(ResourceLocation lootTable, int weight) {
            return this.entry(TableLootEntry.func_216171_a((ResourceLocation)lootTable), weight);
        }

        public LootPoolBuilder lootTableEntry(ResourceLocation lootTable) {
            return this.lootTableEntry(lootTable, 1);
        }

        public LootPoolBuilder lootTableEntry(String namespace, String path, int weight) {
            return this.lootTableEntry(new ResourceLocation(namespace, path), weight);
        }

        public LootPoolBuilder lootTableEntry(String namespace, String path) {
            return this.lootTableEntry(new ResourceLocation(namespace, path));
        }

        public LootPoolBuilder function(ILootFunction function) {
            if (Registry.field_239694_aZ_.func_177774_c((Object)function.func_230425_b_()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered item function '" + function + "'!");
            }
            this.functions.add(function);
            return this;
        }
    }

    public static class LootTableBuilder {
        protected final ResourceLocation identifier;
        private final List<LootPoolBuilder> pools = new ArrayList<LootPoolBuilder>();
        private final List<ILootFunction> functions = new ArrayList<ILootFunction>();
        private LootParameterSet parameters = LootParameterSets.field_216266_g;

        protected LootTableBuilder(ResourceLocation identifier) {
            this.identifier = identifier;
        }

        public LootTableBuilder parameters(LootParameterSet parameters) {
            if (LootParameterSets.func_216257_a((LootParameterSet)parameters) == null) {
                throw new IllegalArgumentException("Cannot use unregistered parameter set '" + parameters + "'!");
            }
            this.parameters = parameters;
            return this;
        }

        public LootTableBuilder blockParameters() {
            return this.parameters(LootParameterSets.field_216267_h);
        }

        public LootTableBuilder chestParameters() {
            return this.parameters(LootParameterSets.field_216261_b);
        }

        public LootTableBuilder pool(Consumer<LootPoolBuilder> poolBuilderConsumer) {
            LootPoolBuilder poolBuilder = new LootPoolBuilder();
            poolBuilderConsumer.accept(poolBuilder);
            this.pools.add(poolBuilder);
            return this;
        }

        public LootTableBuilder function(ILootFunction function) {
            if (Registry.field_239694_aZ_.func_177774_c((Object)function.func_230425_b_()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered item function '" + function + "'!");
            }
            this.functions.add(function);
            return this;
        }
    }
}

