/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.core.registry.RegistryUtil;
import io.netty.util.collection.IntObjectHashMap;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketChannel {
    private final String modid;
    private final String name;
    private final SimpleChannel channel;
    private int index = 0;
    private final HashMap<Class<? extends BasePacket>, Integer> packet_to_index = new HashMap();
    private final IntObjectHashMap<Supplier<? extends BasePacket>> index_to_packet = new IntObjectHashMap();
    private final HashMap<Class<? extends BasePacket>, Boolean> packet_to_queued = new HashMap();

    public static PacketChannel create(String modid, String channelName) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(channelName)) {
            throw new IllegalArgumentException("Channel name '" + channelName + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName() + "' is creating a packet channel for different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is creating a packet channel for modid '" + modid + "'!");
        }
        return new PacketChannel(modid, channelName);
    }

    public static PacketChannel create(String modid) {
        return PacketChannel.create(modid, "main");
    }

    @Deprecated
    public static PacketChannel create() {
        return PacketChannel.create(ModLoadingContext.get().getActiveNamespace(), "main");
    }

    private PacketChannel(String modid, String name) {
        this.modid = modid;
        this.name = name;
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(modid, name), () -> "1", "1"::equals, "1"::equals);
        this.channel.registerMessage(0, InternalPacket.class, (message, buffer) -> InternalPacket.write(this, message, buffer), buffer -> InternalPacket.read(this, buffer), (message, context) -> InternalPacket.handle(this, message, context));
    }

    public <T extends BasePacket> void registerMessage(Class<T> packetClass, Supplier<T> packetSupplier, boolean shouldBeQueued) {
        if (this.packet_to_index.containsKey(packetClass)) {
            throw new IllegalArgumentException("Class '" + packetClass + "' has already been registered!");
        }
        int index = this.index++;
        this.packet_to_index.put(packetClass, index);
        this.index_to_packet.put(index, packetSupplier);
        this.packet_to_queued.put(packetClass, shouldBeQueued);
    }

    public void sendToServer(BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.sendToServer((Object)new InternalPacket().setPacket(packet));
    }

    public void sendToPlayer(PlayerEntity player, BasePacket packet) {
        if (!(player instanceof ServerPlayerEntity)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet);
        this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new InternalPacket().setPacket(packet));
    }

    public void sendToAllPlayers(BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)new InternalPacket().setPacket(packet));
    }

    public void sendToDimension(RegistryKey<World> dimension, BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.send(PacketDistributor.DIMENSION.with(() -> dimension), (Object)new InternalPacket().setPacket(packet));
    }

    public void sendToDimension(World world, BasePacket packet) {
        if (world.field_72995_K) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToDimension((RegistryKey<World>)world.func_234923_W_(), packet);
    }

    public void sendToAllTrackingEntity(Entity entity, BasePacket packet) {
        if (entity.field_70170_p.field_72995_K) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet);
        this.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new InternalPacket().setPacket(packet));
    }

    public void sendToAllNear(RegistryKey<World> world, double x, double y, double z, double radius, BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, radius, world)), (Object)new InternalPacket().setPacket(packet));
    }

    public void sendToAllNear(RegistryKey<World> world, BlockPos pos, double radius, BasePacket packet) {
        this.sendToAllNear(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, radius, packet);
    }

    public void sendToAllNear(World world, double x, double y, double z, double radius, BasePacket packet) {
        if (world.field_72995_K) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear((RegistryKey<World>)world.func_234923_W_(), x, y, z, radius, packet);
    }

    public void sendToAllNear(World world, BlockPos pos, double radius, BasePacket packet) {
        if (world.field_72995_K) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear((RegistryKey<World>)world.func_234923_W_(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, radius, packet);
    }

    private void checkRegistration(BasePacket packet) {
        if (!this.packet_to_index.containsKey(packet.getClass())) {
            throw new IllegalArgumentException("Tried to send unregistered packet '" + packet.getClass() + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
    }

    private void write(BasePacket packet, PacketBuffer buffer) {
        int index = this.packet_to_index.get(packet.getClass());
        buffer.writeInt(index);
        packet.write(buffer);
    }

    private BasePacket read(PacketBuffer buffer) {
        int index = buffer.readInt();
        if (!this.index_to_packet.containsKey(index)) {
            throw new RuntimeException("Received an unregistered packet with index '" + index + "' on channel '" + this.modid + ":" + this.name + "'!");
        }
        BasePacket packet = (BasePacket)((Supplier)this.index_to_packet.get(index)).get();
        packet.read(buffer);
        return packet;
    }

    private void handle(BasePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().setPacketHandled(true);
        PacketContext context = new PacketContext(contextSupplier.get());
        if (packet.verify(context)) {
            if (this.packet_to_queued.get(packet.getClass()).booleanValue()) {
                context.queueTask(() -> packet.handle(context));
            } else {
                packet.handle(context);
            }
        }
    }

    private static class InternalPacket {
        private BasePacket packet;

        private InternalPacket() {
        }

        public static InternalPacket read(PacketChannel channel, PacketBuffer buffer) {
            return new InternalPacket().setPacket(channel.read(buffer));
        }

        public static void write(PacketChannel channel, InternalPacket packet, PacketBuffer buffer) {
            channel.write(packet.packet, buffer);
        }

        public static void handle(PacketChannel channel, InternalPacket packet, Supplier<NetworkEvent.Context> context) {
            channel.handle(packet.packet, context);
        }

        public InternalPacket setPacket(BasePacket packet) {
            this.packet = packet;
            return this;
        }
    }
}

