/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.core.render.CustomItemRenderer;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.core.util.TriFunction;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientRegistrationHandler {
    private static final Field itemIster;
    private static final Map<String, ClientRegistrationHandler> REGISTRATION_HELPER_MAP;
    private final String modid;
    private final Set<ResourceLocation> models = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, Supplier<IBakedModel>> specialModels = new HashMap<ResourceLocation, Supplier<IBakedModel>>();
    private final List<Pair<Supplier<Stream<ResourceLocation>>, Function<IBakedModel, IBakedModel>>> modelOverwrites = new ArrayList<Pair<Supplier<Stream<ResourceLocation>>, Function<IBakedModel, IBakedModel>>>();
    private final List<Pair<Supplier<EntityType<?>>, Supplier<EntityRenderer<?>>>> entityRenderers = new ArrayList();
    private final List<Pair<Supplier<TileEntityType<?>>, Function<TileEntityRendererDispatcher, TileEntityRenderer<?>>>> blockEntityRenderers = new ArrayList();
    private final Map<ResourceLocation, Set<ResourceLocation>> textureAtlasSprites = new HashMap<ResourceLocation, Set<ResourceLocation>>();
    private final List<Pair<Supplier<Item>, Supplier<ItemStackTileEntityRenderer>>> customItemRenderers = new ArrayList<Pair<Supplier<Item>, Supplier<ItemStackTileEntityRenderer>>>();
    private final List<Pair<Supplier<ContainerType<?>>, TriFunction<Container, PlayerInventory, ITextComponent, Screen>>> containerScreens = new ArrayList();
    private final List<Pair<Supplier<Block>, Supplier<RenderType>>> blockRenderTypes = new ArrayList<Pair<Supplier<Block>, Supplier<RenderType>>>();
    private boolean passedModelRegistry;
    private boolean passedModelBake;
    private boolean passedClientSetup;
    private boolean passedTextureStitch;

    private static Supplier<ItemStackTileEntityRenderer> getItemCustomRenderer(Item item) {
        try {
            return (Supplier)itemIster.get(item);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setItemCustomRenderer(Item item, Supplier<ItemStackTileEntityRenderer> customRenderer) {
        try {
            itemIster.set(item, customRenderer);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized ClientRegistrationHandler get(String modid) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String activeMod = ModLoadingContext.get().getActiveNamespace();
        if (activeMod != null && !activeMod.equals("minecraft") && !activeMod.equals("forge")) {
            if (!activeMod.equals(modid)) {
                CoreLib.LOGGER.warn("Mod '" + ModLoadingContext.get().getActiveContainer().getModInfo().getDisplayName() + "' is requesting registration helper for different modid '" + modid + "'!");
            }
        } else if (modid.equals("minecraft") || modid.equals("forge")) {
            CoreLib.LOGGER.warn("Mod is requesting registration helper for modid '" + modid + "'!");
        }
        return REGISTRATION_HELPER_MAP.computeIfAbsent(modid, ClientRegistrationHandler::new);
    }

    private ClientRegistrationHandler(String modid) {
        this.modid = modid;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::handleModelRegistryEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::handleModelBakeEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::handleRegisterRenderersEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::handleTextureStitchEvent);
    }

    public void registerModel(ResourceLocation identifier) {
        if (this.passedModelRegistry) {
            throw new IllegalStateException("Cannot register new models after ModelRegistryEvent has been fired!");
        }
        if (this.models.contains(identifier)) {
            throw new RuntimeException("Duplicate model location '" + identifier + "'!");
        }
        if (this.specialModels.containsKey(identifier)) {
            throw new RuntimeException("Overlapping special model and model location '" + identifier + "'!");
        }
        this.models.add(identifier);
    }

    public void registerModel(String namespace, String identifier) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerModel(new ResourceLocation(namespace, identifier));
    }

    public void registerModel(String identifier) {
        this.registerModel(this.modid, identifier);
    }

    public void registerSpecialModel(String identifier, Supplier<IBakedModel> model) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new special models after ModelBakeEvent has been fired!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        ResourceLocation fullIdentifier = new ResourceLocation(this.modid, identifier);
        if (this.specialModels.containsKey(fullIdentifier)) {
            throw new RuntimeException("Duplicate special model entry '" + fullIdentifier + "'!");
        }
        this.specialModels.put(fullIdentifier, model);
    }

    public void registerSpecialModel(String identifier, IBakedModel model) {
        this.registerSpecialModel(identifier, () -> model);
    }

    public void registerModelOverwrite(ResourceLocation identifier, Function<IBakedModel, IBakedModel> modelOverwrite) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        if (this.specialModels.containsKey(identifier)) {
            throw new RuntimeException("Overlapping special model and model overwrite '" + identifier + "'!");
        }
        this.modelOverwrites.add(Pair.of(() -> Stream.of(identifier), modelOverwrite));
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, Function<IBakedModel, IBakedModel> modelOverwrite) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        if (!RegistryUtil.isValidPath(variant)) {
            throw new IllegalArgumentException("Variant '" + variant + "' must only contain characters [a-z0-9_./-]!");
        }
        ModelResourceLocation fullIdentifier = new ModelResourceLocation(namespace + ":" + identifier + "#" + variant);
        this.registerModelOverwrite((ResourceLocation)fullIdentifier, modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, Function<IBakedModel, IBakedModel> modelOverwrite) {
        if (!RegistryUtil.isValidNamespace(namespace)) {
            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidPath(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
        }
        ResourceLocation fullIdentifier = new ResourceLocation(namespace, identifier);
        this.registerModelOverwrite(fullIdentifier, modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, Supplier<IBakedModel> modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, variant, (IBakedModel model) -> (IBakedModel)modelOverwrite.get());
    }

    public void registerModelOverwrite(String namespace, String identifier, Supplier<IBakedModel> modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, (IBakedModel model) -> (IBakedModel)modelOverwrite.get());
    }

    public void registerModelOverwrite(String namespace, String identifier, String variant, IBakedModel modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, variant, (IBakedModel model) -> modelOverwrite);
    }

    public void registerModelOverwrite(String namespace, String identifier, IBakedModel modelOverwrite) {
        this.registerModelOverwrite(namespace, identifier, (IBakedModel model) -> modelOverwrite);
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, Function<IBakedModel, IBakedModel> modelOverwrite) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.modelOverwrites.add(Pair.of(() -> ((Block)block.get()).func_176194_O().func_177619_a().stream().map(BlockModelShapes::func_209554_c).map(ResourceLocation.class::cast), modelOverwrite));
        this.registerItemModelOverwrite(() -> ((Block)block.get()).func_199767_j(), modelOverwrite);
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, Supplier<IBakedModel> modelOverwrite) {
        this.registerBlockModelOverwrite(block, (IBakedModel model) -> (IBakedModel)modelOverwrite.get());
    }

    public void registerBlockModelOverwrite(Supplier<Block> block, IBakedModel modelOverwrite) {
        this.registerBlockModelOverwrite(block, (IBakedModel model) -> modelOverwrite);
    }

    public void registerItemModelOverwrite(Supplier<Item> item, Function<IBakedModel, IBakedModel> modelOverwrite) {
        if (this.passedModelBake) {
            throw new IllegalStateException("Cannot register new model overwrites after ModelBakeEvent has been fired!");
        }
        this.modelOverwrites.add(Pair.of(() -> Stream.of(new ModelResourceLocation(Registries.ITEMS.getIdentifier((Item)item.get()), "inventory")), modelOverwrite));
    }

    public void registerItemModelOverwrite(Supplier<Item> item, Supplier<IBakedModel> modelOverwrite) {
        this.registerItemModelOverwrite(item, (IBakedModel model) -> (IBakedModel)modelOverwrite.get());
    }

    public void registerItemModelOverwrite(Supplier<Item> item, IBakedModel modelOverwrite) {
        this.registerItemModelOverwrite(item, (IBakedModel model) -> modelOverwrite);
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, Supplier<EntityRenderer<? super T>> entityRenderer) {
        if (this.passedClientSetup) {
            throw new IllegalStateException("Cannot register new renderers after RegisterRenderers has been fired!");
        }
        this.entityRenderers.add(Pair.of(entityType, entityRenderer));
    }

    public <T extends Entity> void registerEntityRenderer(Supplier<EntityType<T>> entityType, EntityRenderer<? super T> entityRenderer) {
        this.registerEntityRenderer(entityType, () -> entityRenderer);
    }

    public <T extends TileEntity> void registerBlockEntityRenderer(Supplier<TileEntityType<T>> entityType, Function<TileEntityRendererDispatcher, TileEntityRenderer<? super T>> blockEntityRenderer) {
        if (this.passedClientSetup) {
            throw new IllegalStateException("Cannot register new renderers after RegisterRenderers has been fired!");
        }
        this.blockEntityRenderers.add(Pair.of(entityType, blockEntityRenderer));
    }

    public <T extends TileEntity> void registerBlockEntityRenderer(Supplier<TileEntityType<T>> entityType, Supplier<TileEntityRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (TileEntityRendererDispatcher context) -> (TileEntityRenderer)blockEntityRenderer.get());
    }

    public <T extends TileEntity> void registerBlockEntityRenderer(Supplier<TileEntityType<T>> entityType, TileEntityRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (TileEntityRendererDispatcher context) -> blockEntityRenderer);
    }

    public <T extends TileEntity> void registerCustomBlockEntityRenderer(Supplier<TileEntityType<T>> entityType, Supplier<CustomBlockEntityRenderer<? super T>> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (TileEntityRendererDispatcher context) -> CustomBlockEntityRenderer.of((CustomBlockEntityRenderer)blockEntityRenderer.get()));
    }

    public <T extends TileEntity> void registerCustomBlockEntityRenderer(Supplier<TileEntityType<T>> entityType, CustomBlockEntityRenderer<? super T> blockEntityRenderer) {
        this.registerBlockEntityRenderer(entityType, (TileEntityRendererDispatcher context) -> CustomBlockEntityRenderer.of(blockEntityRenderer));
    }

    public void registerAtlasSprite(ResourceLocation textureAtlas, ResourceLocation spriteLocation) {
        if (this.passedTextureStitch) {
            throw new IllegalStateException("Cannot register new models after TextureStitchEvent has been fired!");
        }
        if (textureAtlas == null) {
            throw new IllegalArgumentException("Texture atlas must not be null!");
        }
        this.textureAtlasSprites.putIfAbsent(textureAtlas, new HashSet());
        if (this.textureAtlasSprites.get(textureAtlas).contains(spriteLocation)) {
            throw new RuntimeException("Duplicate sprite registration '" + spriteLocation + "' for atlas '" + textureAtlas + "'!");
        }
        this.textureAtlasSprites.get(textureAtlas).add(spriteLocation);
    }

    public void registerAtlasSprite(ResourceLocation textureAtlas, String spriteLocation) {
        if (!RegistryUtil.isValidPath(spriteLocation)) {
            throw new IllegalArgumentException("Sprite location '" + spriteLocation + "' must only contain characters [a-z0-9_./-]!");
        }
        this.registerAtlasSprite(textureAtlas, new ResourceLocation(this.modid, spriteLocation));
    }

    public void registerItemRenderer(Supplier<Item> item, Supplier<ItemStackTileEntityRenderer> itemRenderer) {
        if (this.passedClientSetup) {
            throw new IllegalStateException("Cannot register new renderers after item RegistryEvent has been fired!");
        }
        this.customItemRenderers.add(Pair.of(item, itemRenderer));
    }

    public void registerItemRenderer(Supplier<Item> item, ItemStackTileEntityRenderer itemRenderer) {
        this.registerItemRenderer(item, () -> itemRenderer);
    }

    public void registerItemRenderer(Item item, Supplier<ItemStackTileEntityRenderer> itemRenderer) {
        this.registerItemRenderer(() -> item, itemRenderer);
    }

    public void registerItemRenderer(Item item, ItemStackTileEntityRenderer itemRenderer) {
        this.registerItemRenderer(() -> item, () -> itemRenderer);
    }

    public void registerCustomItemRenderer(Supplier<Item> item, Supplier<CustomItemRenderer> itemRenderer) {
        this.registerItemRenderer(item, () -> CustomItemRenderer.of((CustomItemRenderer)itemRenderer.get()));
    }

    public void registerCustomItemRenderer(Supplier<Item> item, CustomItemRenderer itemRenderer) {
        this.registerItemRenderer(item, () -> CustomItemRenderer.of(itemRenderer));
    }

    public void registerCustomItemRenderer(Item item, Supplier<CustomItemRenderer> itemRenderer) {
        this.registerItemRenderer(() -> item, () -> CustomItemRenderer.of((CustomItemRenderer)itemRenderer.get()));
    }

    public void registerCustomItemRenderer(Item item, CustomItemRenderer itemRenderer) {
        this.registerItemRenderer(() -> item, () -> CustomItemRenderer.of(itemRenderer));
    }

    public <T extends Container, U extends Screen> void registerContainerScreen(Supplier<ContainerType<T>> menuType, TriFunction<T, PlayerInventory, ITextComponent, U> screenSupplier) {
        if (this.passedClientSetup) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.containerScreens.add(Pair.of(menuType, screenSupplier));
    }

    public <T extends Container, U extends Screen> void registerContainerScreen(Supplier<ContainerType<T>> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(menuType, (T container, PlayerInventory inventory, ITextComponent title) -> (Screen)screenSupplier.apply(container));
    }

    public <T extends Container, U extends Screen> void registerContainerScreen(ContainerType<T> menuType, TriFunction<T, PlayerInventory, ITextComponent, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, screenSupplier);
    }

    public <T extends Container, U extends Screen> void registerContainerScreen(ContainerType<T> menuType, Function<T, U> screenSupplier) {
        this.registerContainerScreen(() -> menuType, (T container, PlayerInventory inventory, ITextComponent title) -> (Screen)screenSupplier.apply(container));
    }

    public void registerBlockModelRenderType(Supplier<Block> block, Supplier<RenderType> renderTypeSupplier) {
        if (this.passedClientSetup) {
            throw new IllegalStateException("Cannot register new menu screens after the ClientInitialization event has been fired!");
        }
        this.blockRenderTypes.add(Pair.of(block, renderTypeSupplier));
    }

    public void registerBlockModelRenderType(Supplier<Block> block, RenderType renderType) {
        this.registerBlockModelRenderType(block, renderType);
    }

    public void registerBlockModelRenderType(Block block, Supplier<RenderType> renderTypeSupplier) {
        this.registerBlockModelRenderType(() -> block, renderTypeSupplier);
    }

    public void registerBlockModelSolidRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::func_228639_c_);
    }

    public void registerBlockModelSolidRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::func_228639_c_);
    }

    public void registerBlockModelCutoutMippedRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::func_228641_d_);
    }

    public void registerBlockModelCutoutMippedRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::func_228641_d_);
    }

    public void registerBlockModelCutoutRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::func_228643_e_);
    }

    public void registerBlockModelCutoutRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::func_228643_e_);
    }

    public void registerBlockModelTranslucentRenderType(Supplier<Block> block) {
        this.registerBlockModelRenderType(block, RenderType::func_228645_f_);
    }

    public void registerBlockModelTranslucentRenderType(Block block) {
        this.registerBlockModelRenderType(block, RenderType::func_228645_f_);
    }

    private void handleModelRegistryEvent(ModelRegistryEvent e) {
        this.passedModelRegistry = true;
        for (ResourceLocation model : this.models) {
            ModelLoader.addSpecialModel((ResourceLocation)model);
        }
    }

    private void handleModelBakeEvent(ModelBakeEvent e) {
        this.passedModelBake = true;
        for (Map.Entry<ResourceLocation, Supplier<IBakedModel>> entry : this.specialModels.entrySet()) {
            ResourceLocation identifier = entry.getKey();
            if (e.getModelRegistry().containsKey(identifier)) {
                throw new RuntimeException("Special model '" + identifier + "' is trying to overwrite another model!");
            }
            IBakedModel model = entry.getValue().get();
            if (model == null) {
                throw new RuntimeException("Got null object for special model '" + entry.getKey() + "'!");
            }
            e.getModelRegistry().put(entry.getKey(), model);
        }
        for (Pair pair : this.modelOverwrites) {
            List modelIdentifiers;
            try (Stream stream = (Stream)((Supplier)pair.left()).get();){
                modelIdentifiers = stream.collect(Collectors.toList());
            }
            for (ResourceLocation identifier : modelIdentifiers) {
                if (!e.getModelRegistry().containsKey(identifier)) {
                    throw new RuntimeException("No model registered for model overwrite '" + identifier + "'!");
                }
                IBakedModel model = (IBakedModel)e.getModelRegistry().get(identifier);
                model = (IBakedModel)((Function)pair.right()).apply(model);
                if (model == null) {
                    throw new RuntimeException("Model overwrite for '" + identifier + "' returned a null model!");
                }
                e.getModelRegistry().put(identifier, model);
            }
        }
    }

    private void handleRegisterRenderersEvent(FMLClientSetupEvent e) {
        this.passedClientSetup = true;
        HashSet entityTypes = new HashSet();
        for (Pair<Supplier<EntityType<?>>, Supplier<EntityRenderer<?>>> entry : this.entityRenderers) {
            EntityType<?> entityType = entry.left().get();
            if (entityType == null) {
                throw new RuntimeException("Entity renderer registered with null entity type!");
            }
            if (entityTypes.contains(entityType)) {
                throw new RuntimeException("Duplicate entity renderer for entity type '" + Registries.ENTITY_TYPES.getIdentifier(entityType) + "'!");
            }
            EntityRenderer entityRenderer = (EntityRenderer)((Supplier)entry.right()).get();
            if (entityRenderer == null) {
                throw new RuntimeException("Got null entity renderer for entity type '" + Registries.ENTITY_TYPES.getIdentifier(entityType) + "!");
            }
            entityTypes.add(entityType);
            ClientUtils.getMinecraft().func_175598_ae().func_229087_a_(entityType, entityRenderer);
        }
        HashSet<TileEntityType> blockEntityTypes = new HashSet<TileEntityType>();
        for (Pair pair : this.blockEntityRenderers) {
            TileEntityType tileEntityType = (TileEntityType)((Supplier)pair.left()).get();
            if (tileEntityType == null) {
                throw new RuntimeException("Block entity renderer registered with null block entity type!");
            }
            if (blockEntityTypes.contains(tileEntityType)) {
                throw new RuntimeException("Duplicate block entity renderer for block entity type '" + Registries.BLOCK_ENTITY_TYPES.getIdentifier(tileEntityType) + "'!");
            }
            blockEntityTypes.add(tileEntityType);
            ClientRegistry.bindTileEntityRenderer((TileEntityType)tileEntityType, (Function)((Function)pair.right()));
        }
        HashSet<Item> items = new HashSet<Item>();
        for (Pair<Supplier<Item>, Supplier<ItemStackTileEntityRenderer>> pair : this.customItemRenderers) {
            Item item = pair.left().get();
            if (item == null) {
                throw new RuntimeException("Custom item renderer registered with null item!");
            }
            if (items.contains(item)) {
                throw new RuntimeException("Duplicate custom item renderer for item '" + Registries.ITEMS.getIdentifier(item) + "'!");
            }
            if (ClientRegistrationHandler.getItemCustomRenderer(item) != null) {
                throw new RuntimeException("Item '" + Registries.ITEMS.getIdentifier(item) + "' already has a custom item renderer set!");
            }
            ItemStackTileEntityRenderer customRenderer = pair.right().get();
            if (customRenderer == null) {
                throw new RuntimeException("Got null custom item renderer for item '" + Registries.ITEMS.getIdentifier(item) + "'!");
            }
            items.add(item);
            ClientRegistrationHandler.setItemCustomRenderer(item, () -> customRenderer);
        }
        HashSet hashSet = new HashSet();
        for (Pair<Supplier<ContainerType<?>>, TriFunction<Container, PlayerInventory, ITextComponent, Screen>> pair : this.containerScreens) {
            ContainerType<?> menuType = pair.left().get();
            if (menuType == null) {
                throw new RuntimeException("Container screen registered with null menu type!");
            }
            if (hashSet.contains(menuType)) {
                throw new RuntimeException("Duplicate container screen for menu type '" + Registries.MENU_TYPES.getIdentifier(menuType) + "'!");
            }
            hashSet.add(menuType);
            ScreenManager.func_216911_a(menuType, pair.right()::apply);
        }
        HashSet<Block> hashSet2 = new HashSet<Block>();
        for (Pair<Supplier<Block>, Supplier<RenderType>> entry : this.blockRenderTypes) {
            Block block = entry.left().get();
            if (block == null) {
                throw new RuntimeException("Block render type registered for null block!");
            }
            if (hashSet2.contains(block)) {
                throw new RuntimeException("Duplicate render type for block '" + Registries.BLOCKS.getIdentifier(block) + "'!");
            }
            RenderType renderType = entry.right().get();
            if (renderType == null) {
                throw new RuntimeException("Got null render type for block '" + Registries.BLOCKS.getIdentifier(block) + "'!");
            }
            hashSet2.add(block);
            RenderTypeLookup.setRenderLayer((Block)block, (RenderType)renderType);
        }
    }

    private void handleTextureStitchEvent(TextureStitchEvent.Pre e) {
        this.passedTextureStitch = true;
        Set<ResourceLocation> sprites = this.textureAtlasSprites.get(e.getMap().func_229223_g_());
        if (sprites == null) {
            return;
        }
        sprites.forEach(arg_0 -> ((TextureStitchEvent.Pre)e).addSprite(arg_0));
    }

    static {
        try {
            itemIster = Item.class.getDeclaredField("ister");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        REGISTRATION_HELPER_MAP = new HashMap<String, ClientRegistrationHandler>();
    }
}

