/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.render.RenderConfiguration;
import com.supermartijn642.core.render.RenderStateConfiguration;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;

public class RenderUtils {
    private static final RenderConfiguration LINES = RenderConfiguration.create("supermartijn642corelib", "lines", DefaultVertexFormats.field_181706_f, RenderConfiguration.PrimitiveType.LINES, 128, true, true, RenderStateConfiguration.builder().useDefaultLineWidth().useTranslucentTransparency().useViewOffsetZLayering().disableCulling().useLessThanOrEqualDepthTest().disableDepthMask().build());
    private static final RenderConfiguration LINES_NO_DEPTH = RenderConfiguration.create("supermartijn642corelib", "lines_no_depth", DefaultVertexFormats.field_181706_f, RenderConfiguration.PrimitiveType.LINES, 128, true, true, RenderStateConfiguration.builder().useDefaultLineWidth().useTranslucentTransparency().useViewOffsetZLayering().disableCulling().disableDepthTest().disableDepthMask().build());
    private static final RenderConfiguration QUADS = RenderConfiguration.create("supermartijn642corelib", "quads", DefaultVertexFormats.field_181706_f, RenderConfiguration.PrimitiveType.QUADS, 256, false, true, RenderStateConfiguration.builder().useTranslucentTransparency().disableTexture().disableCulling().useLessThanOrEqualDepthTest().disableDepthMask().build());
    private static final RenderConfiguration QUADS_NO_DEPTH = RenderConfiguration.create("supermartijn642corelib", "quads_no_depth", DefaultVertexFormats.field_181706_f, RenderConfiguration.PrimitiveType.QUADS, 256, false, true, RenderStateConfiguration.builder().useTranslucentTransparency().disableTexture().disableCulling().disableDepthTest().disableDepthMask().build());

    public static Vector3d getCameraPosition() {
        return ClientUtils.getMinecraft().func_175598_ae().field_217783_c.func_216785_c();
    }

    public static IRenderTypeBuffer.Impl getMainBufferSource() {
        return ClientUtils.getMinecraft().func_228019_au_().func_228487_b_();
    }

    public static void renderShape(MatrixStack poseStack, BlockShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderConfiguration renderConfiguration = depthTest ? LINES : LINES_NO_DEPTH;
        IRenderTypeBuffer.Impl bufferSource = RenderUtils.getMainBufferSource();
        IVertexBuilder builder = renderConfiguration.begin((IRenderTypeBuffer)bufferSource);
        Matrix4f matrix4f = poseStack.func_227866_c_().func_227870_a_();
        shape.forEachEdge((x1, y1, z1, x2, y2, z2) -> {
            builder.func_227888_a_(matrix4f, (float)x1, (float)y1, (float)z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix4f, (float)x2, (float)y2, (float)z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        });
        renderConfiguration.end(bufferSource);
    }

    public static void renderShapeSides(MatrixStack poseStack, BlockShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderConfiguration renderConfiguration = depthTest ? QUADS : QUADS_NO_DEPTH;
        IRenderTypeBuffer.Impl bufferSource = RenderUtils.getMainBufferSource();
        IVertexBuilder builder = renderConfiguration.begin((IRenderTypeBuffer)bufferSource);
        Matrix4f matrix = poseStack.func_227866_c_().func_227870_a_();
        shape.forEachBox(box -> {
            float minX = (float)box.field_72340_a;
            float maxX = (float)box.field_72336_d;
            float minY = (float)box.field_72338_b;
            float maxY = (float)box.field_72337_e;
            float minZ = (float)box.field_72339_c;
            float maxZ = (float)box.field_72334_f;
            builder.func_227888_a_(matrix, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix, maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        });
        renderConfiguration.end(bufferSource);
    }

    public static void renderShape(MatrixStack poseStack, VoxelShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, alpha, depthTest);
    }

    public static void renderShapeSides(MatrixStack poseStack, VoxelShape shape, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, alpha, depthTest);
    }

    public static void renderBox(MatrixStack poseStack, AxisAlignedBB box, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, alpha, depthTest);
    }

    public static void renderBoxSides(MatrixStack poseStack, AxisAlignedBB box, float red, float green, float blue, float alpha, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, alpha, depthTest);
    }

    public static void renderShape(MatrixStack poseStack, BlockShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, shape, red, green, blue, 1.0f, depthTest);
    }

    public static void renderShapeSides(MatrixStack poseStack, BlockShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, shape, red, green, blue, 1.0f, depthTest);
    }

    public static void renderShape(MatrixStack poseStack, VoxelShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(shape), red, green, blue, 1.0f, depthTest);
    }

    public static void renderShapeSides(MatrixStack poseStack, VoxelShape shape, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(shape), red, green, blue, 1.0f, depthTest);
    }

    public static void renderBox(MatrixStack poseStack, AxisAlignedBB box, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShape(poseStack, BlockShape.create(box), red, green, blue, 1.0f, depthTest);
    }

    public static void renderBoxSides(MatrixStack poseStack, AxisAlignedBB box, float red, float green, float blue, boolean depthTest) {
        RenderUtils.renderShapeSides(poseStack, BlockShape.create(box), red, green, blue, 1.0f, depthTest);
    }
}

