/*
 * Decompiled with CFR 0.152.
 */
package com.doctor.vampiricageing.actions;

import com.doctor.vampiricageing.capabilities.IAgeingCapability;
import com.doctor.vampiricageing.capabilities.VampiricAgeingCapabilityManager;
import com.doctor.vampiricageing.config.CommonConfig;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.particle.GenericParticleData;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class CelerityAction
extends DefaultVampireAction
implements ILastingAction<IVampirePlayer> {
    public static final UUID CELERITY_UUID = UUID.fromString("31c9aa6e-38e9-40ad-868f-b494981605a8");

    public boolean activate(IVampirePlayer vampire, IAction.ActivationContext context) {
        vampire.getRepresentingPlayer().func_110148_a(Attributes.field_233821_d_).func_233769_c_(new AttributeModifier(CELERITY_UUID, "SPEED_CELERITY_INCREASE", ((Double)CommonConfig.celerityActionMultiplier.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        return true;
    }

    public boolean canBeUsedBy(IVampirePlayer vampire) {
        return ((IAgeingCapability)VampiricAgeingCapabilityManager.getAge((LivingEntity)vampire.getRepresentingPlayer()).orElse(null)).getAge() >= (Integer)CommonConfig.celerityActionRank.get();
    }

    public int getCooldown() {
        return (Integer)CommonConfig.celerityActionCooldown.get() * 20;
    }

    public int getDuration(int i) {
        return 20 * (Integer)CommonConfig.celerityActionDuration.get();
    }

    public boolean isEnabled() {
        return (Boolean)CommonConfig.celerityAction.get();
    }

    public void onActivatedClient(IVampirePlayer vampire) {
    }

    public void onDeactivated(IVampirePlayer vampire) {
        VampiricAgeingCapabilityManager.removeModifier(vampire.getRepresentingPlayer().func_110148_a(Attributes.field_233821_d_), CELERITY_UUID);
    }

    public void onReActivated(IVampirePlayer vampire) {
    }

    public boolean onUpdate(IVampirePlayer vampire) {
        if (!vampire.getRepresentingPlayer().func_130014_f_().field_72995_K) {
            PlayerEntity player = vampire.getRepresentingPlayer();
            ModParticles.spawnParticlesServer((World)player.func_130014_f_(), (IParticleData)new GenericParticleData((ParticleType)ModParticles.GENERIC.get(), new ResourceLocation("minecraft", "generic_4"), 5, 0xD3D3D3, 0.1f), (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (int)3, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return false;
    }
}

